/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.StackSummary;

@SdkInternalApi
public class StackSummaryMarshaller {
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<Integer> LAYERSCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayersCount").build();
    private static final MarshallingInfo<Integer> APPSCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppsCount").build();
    private static final MarshallingInfo<StructuredPojo> INSTANCESCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstancesCount").build();
    private static final StackSummaryMarshaller instance = new StackSummaryMarshaller();

    public static StackSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(StackSummary stackSummary, ProtocolMarshaller protocolMarshaller) {
        if (stackSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)stackSummary.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)stackSummary.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)stackSummary.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)stackSummary.layersCount(), LAYERSCOUNT_BINDING);
            protocolMarshaller.marshall((Object)stackSummary.appsCount(), APPSCOUNT_BINDING);
            protocolMarshaller.marshall((Object)stackSummary.instancesCount(), INSTANCESCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

