/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.Instance;

@SdkInternalApi
public class InstanceMarshaller {
    private static final MarshallingInfo<String> AGENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AgentVersion").build();
    private static final MarshallingInfo<String> AMIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AmiId").build();
    private static final MarshallingInfo<String> ARCHITECTURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Architecture").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<String> AUTOSCALINGTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingType").build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").build();
    private static final MarshallingInfo<List> BLOCKDEVICEMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlockDeviceMappings").build();
    private static final MarshallingInfo<String> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").build();
    private static final MarshallingInfo<Boolean> EBSOPTIMIZED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsOptimized").build();
    private static final MarshallingInfo<String> EC2INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2InstanceId").build();
    private static final MarshallingInfo<String> ECSCLUSTERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EcsClusterArn").build();
    private static final MarshallingInfo<String> ECSCONTAINERINSTANCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EcsContainerInstanceArn").build();
    private static final MarshallingInfo<String> ELASTICIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticIp").build();
    private static final MarshallingInfo<String> HOSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hostname").build();
    private static final MarshallingInfo<String> INFRASTRUCTURECLASS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InfrastructureClass").build();
    private static final MarshallingInfo<Boolean> INSTALLUPDATESONBOOT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstallUpdatesOnBoot").build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").build();
    private static final MarshallingInfo<String> INSTANCEPROFILEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceProfileArn").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").build();
    private static final MarshallingInfo<String> LASTSERVICEERRORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastServiceErrorId").build();
    private static final MarshallingInfo<List> LAYERIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayerIds").build();
    private static final MarshallingInfo<String> OS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Os").build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Platform").build();
    private static final MarshallingInfo<String> PRIVATEDNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivateDns").build();
    private static final MarshallingInfo<String> PRIVATEIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivateIp").build();
    private static final MarshallingInfo<String> PUBLICDNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicDns").build();
    private static final MarshallingInfo<String> PUBLICIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicIp").build();
    private static final MarshallingInfo<String> REGISTEREDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegisteredBy").build();
    private static final MarshallingInfo<String> REPORTEDAGENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReportedAgentVersion").build();
    private static final MarshallingInfo<StructuredPojo> REPORTEDOS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReportedOs").build();
    private static final MarshallingInfo<String> ROOTDEVICETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RootDeviceType").build();
    private static final MarshallingInfo<String> ROOTDEVICEVOLUMEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RootDeviceVolumeId").build();
    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIds").build();
    private static final MarshallingInfo<String> SSHHOSTDSAKEYFINGERPRINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshHostDsaKeyFingerprint").build();
    private static final MarshallingInfo<String> SSHHOSTRSAKEYFINGERPRINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshHostRsaKeyFingerprint").build();
    private static final MarshallingInfo<String> SSHKEYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshKeyName").build();
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").build();
    private static final MarshallingInfo<String> TENANCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tenancy").build();
    private static final MarshallingInfo<String> VIRTUALIZATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VirtualizationType").build();
    private static final InstanceMarshaller instance = new InstanceMarshaller();

    public static InstanceMarshaller getInstance() {
        return instance;
    }

    public void marshall(Instance instance, ProtocolMarshaller protocolMarshaller) {
        if (instance == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instance.agentVersion(), AGENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)instance.amiId(), AMIID_BINDING);
            protocolMarshaller.marshall((Object)instance.architecture(), ARCHITECTURE_BINDING);
            protocolMarshaller.marshall((Object)instance.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)instance.autoScalingType(), AUTOSCALINGTYPE_BINDING);
            protocolMarshaller.marshall((Object)instance.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall(instance.blockDeviceMappings(), BLOCKDEVICEMAPPINGS_BINDING);
            protocolMarshaller.marshall((Object)instance.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)instance.ebsOptimized(), EBSOPTIMIZED_BINDING);
            protocolMarshaller.marshall((Object)instance.ec2InstanceId(), EC2INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)instance.ecsClusterArn(), ECSCLUSTERARN_BINDING);
            protocolMarshaller.marshall((Object)instance.ecsContainerInstanceArn(), ECSCONTAINERINSTANCEARN_BINDING);
            protocolMarshaller.marshall((Object)instance.elasticIp(), ELASTICIP_BINDING);
            protocolMarshaller.marshall((Object)instance.hostname(), HOSTNAME_BINDING);
            protocolMarshaller.marshall((Object)instance.infrastructureClass(), INFRASTRUCTURECLASS_BINDING);
            protocolMarshaller.marshall((Object)instance.installUpdatesOnBoot(), INSTALLUPDATESONBOOT_BINDING);
            protocolMarshaller.marshall((Object)instance.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)instance.instanceProfileArn(), INSTANCEPROFILEARN_BINDING);
            protocolMarshaller.marshall((Object)instance.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)instance.lastServiceErrorId(), LASTSERVICEERRORID_BINDING);
            protocolMarshaller.marshall(instance.layerIds(), LAYERIDS_BINDING);
            protocolMarshaller.marshall((Object)instance.os(), OS_BINDING);
            protocolMarshaller.marshall((Object)instance.platform(), PLATFORM_BINDING);
            protocolMarshaller.marshall((Object)instance.privateDns(), PRIVATEDNS_BINDING);
            protocolMarshaller.marshall((Object)instance.privateIp(), PRIVATEIP_BINDING);
            protocolMarshaller.marshall((Object)instance.publicDns(), PUBLICDNS_BINDING);
            protocolMarshaller.marshall((Object)instance.publicIp(), PUBLICIP_BINDING);
            protocolMarshaller.marshall((Object)instance.registeredBy(), REGISTEREDBY_BINDING);
            protocolMarshaller.marshall((Object)instance.reportedAgentVersion(), REPORTEDAGENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)instance.reportedOs(), REPORTEDOS_BINDING);
            protocolMarshaller.marshall((Object)instance.rootDeviceType(), ROOTDEVICETYPE_BINDING);
            protocolMarshaller.marshall((Object)instance.rootDeviceVolumeId(), ROOTDEVICEVOLUMEID_BINDING);
            protocolMarshaller.marshall(instance.securityGroupIds(), SECURITYGROUPIDS_BINDING);
            protocolMarshaller.marshall((Object)instance.sshHostDsaKeyFingerprint(), SSHHOSTDSAKEYFINGERPRINT_BINDING);
            protocolMarshaller.marshall((Object)instance.sshHostRsaKeyFingerprint(), SSHHOSTRSAKEYFINGERPRINT_BINDING);
            protocolMarshaller.marshall((Object)instance.sshKeyName(), SSHKEYNAME_BINDING);
            protocolMarshaller.marshall((Object)instance.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)instance.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)instance.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall((Object)instance.tenancy(), TENANCY_BINDING);
            protocolMarshaller.marshall((Object)instance.virtualizationType(), VIRTUALIZATIONTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

