/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.EbsBlockDevice;

@SdkInternalApi
public class EbsBlockDeviceMarshaller {
    private static final MarshallingInfo<String> SNAPSHOTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnapshotId").build();
    private static final MarshallingInfo<Integer> IOPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Iops").build();
    private static final MarshallingInfo<Integer> VOLUMESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeSize").build();
    private static final MarshallingInfo<String> VOLUMETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeType").build();
    private static final MarshallingInfo<Boolean> DELETEONTERMINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeleteOnTermination").build();
    private static final EbsBlockDeviceMarshaller instance = new EbsBlockDeviceMarshaller();

    public static EbsBlockDeviceMarshaller getInstance() {
        return instance;
    }

    public void marshall(EbsBlockDevice ebsBlockDevice, ProtocolMarshaller protocolMarshaller) {
        if (ebsBlockDevice == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)ebsBlockDevice.snapshotId(), SNAPSHOTID_BINDING);
            protocolMarshaller.marshall((Object)ebsBlockDevice.iops(), IOPS_BINDING);
            protocolMarshaller.marshall((Object)ebsBlockDevice.volumeSize(), VOLUMESIZE_BINDING);
            protocolMarshaller.marshall((Object)ebsBlockDevice.volumeType(), VOLUMETYPE_BINDING);
            protocolMarshaller.marshall((Object)ebsBlockDevice.deleteOnTermination(), DELETEONTERMINATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

