/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsLogStream;

@SdkInternalApi
public class CloudWatchLogsLogStreamMarshaller {
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogGroupName").build();
    private static final MarshallingInfo<String> DATETIMEFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatetimeFormat").build();
    private static final MarshallingInfo<String> TIMEZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeZone").build();
    private static final MarshallingInfo<String> FILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("File").build();
    private static final MarshallingInfo<String> FILEFINGERPRINTLINES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileFingerprintLines").build();
    private static final MarshallingInfo<String> MULTILINESTARTPATTERN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MultiLineStartPattern").build();
    private static final MarshallingInfo<String> INITIALPOSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InitialPosition").build();
    private static final MarshallingInfo<String> ENCODING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Encoding").build();
    private static final MarshallingInfo<Integer> BUFFERDURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BufferDuration").build();
    private static final MarshallingInfo<Integer> BATCHCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BatchCount").build();
    private static final MarshallingInfo<Integer> BATCHSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BatchSize").build();
    private static final CloudWatchLogsLogStreamMarshaller instance = new CloudWatchLogsLogStreamMarshaller();

    public static CloudWatchLogsLogStreamMarshaller getInstance() {
        return instance;
    }

    public void marshall(CloudWatchLogsLogStream cloudWatchLogsLogStream, ProtocolMarshaller protocolMarshaller) {
        if (cloudWatchLogsLogStream == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.datetimeFormat(), DATETIMEFORMAT_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.timeZone(), TIMEZONE_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.file(), FILE_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.fileFingerprintLines(), FILEFINGERPRINTLINES_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.multiLineStartPattern(), MULTILINESTARTPATTERN_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.initialPosition(), INITIALPOSITION_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.encoding(), ENCODING_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.bufferDuration(), BUFFERDURATION_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.batchCount(), BATCHCOUNT_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchLogsLogStream.batchSize(), BATCHSIZE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

