/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.opsworks.model.Stack;
import software.amazon.awssdk.services.opsworks.model.StacksCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeStacksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeStacksResponse> {
    private final List<Stack> stacks;

    private DescribeStacksResponse(BuilderImpl builder) {
        this.stacks = builder.stacks;
    }

    public List<Stack> stacks() {
        return this.stacks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stacks() == null ? 0 : this.stacks().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStacksResponse)) {
            return false;
        }
        DescribeStacksResponse other = (DescribeStacksResponse)((Object)obj);
        if (other.stacks() == null ^ this.stacks() == null) {
            return false;
        }
        return other.stacks() == null || other.stacks().equals(this.stacks());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stacks() != null) {
            sb.append("Stacks: ").append(this.stacks()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Stack> stacks = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStacksResponse model) {
            this.setStacks(model.stacks);
        }

        public final Collection<Stack> getStacks() {
            return this.stacks;
        }

        @Override
        public final Builder stacks(Collection<Stack> stacks) {
            this.stacks = StacksCopier.copy(stacks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stacks(Stack ... stacks) {
            if (this.stacks == null) {
                this.stacks = new SdkInternalList(stacks.length);
            }
            for (Stack e : stacks) {
                this.stacks.add(e);
            }
            return this;
        }

        public final void setStacks(Collection<Stack> stacks) {
            this.stacks = StacksCopier.copy(stacks);
        }

        @SafeVarargs
        public final void setStacks(Stack ... stacks) {
            if (this.stacks == null) {
                this.stacks = new SdkInternalList(stacks.length);
            }
            for (Stack e : stacks) {
                this.stacks.add(e);
            }
        }

        public DescribeStacksResponse build() {
            return new DescribeStacksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeStacksResponse> {
        public Builder stacks(Collection<Stack> var1);

        public Builder stacks(Stack ... var1);
    }
}

