/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeElasticLoadBalancersRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeElasticLoadBalancersRequest> {
    private final String stackId;
    private final List<String> layerIds;

    private DescribeElasticLoadBalancersRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.layerIds = builder.layerIds;
    }

    public String stackId() {
        return this.stackId;
    }

    public List<String> layerIds() {
        return this.layerIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.layerIds() == null ? 0 : this.layerIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticLoadBalancersRequest)) {
            return false;
        }
        DescribeElasticLoadBalancersRequest other = (DescribeElasticLoadBalancersRequest)((Object)obj);
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.layerIds() == null ^ this.layerIds() == null) {
            return false;
        }
        return other.layerIds() == null || other.layerIds().equals(this.layerIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.layerIds() != null) {
            sb.append("LayerIds: ").append(this.layerIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackId;
        private List<String> layerIds = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticLoadBalancersRequest model) {
            this.setStackId(model.stackId);
            this.setLayerIds(model.layerIds);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getLayerIds() {
            return this.layerIds;
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String ... layerIds) {
            if (this.layerIds == null) {
                this.layerIds = new SdkInternalList(layerIds.length);
            }
            for (String e : layerIds) {
                this.layerIds.add(e);
            }
            return this;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        @SafeVarargs
        public final void setLayerIds(String ... layerIds) {
            if (this.layerIds == null) {
                this.layerIds = new SdkInternalList(layerIds.length);
            }
            for (String e : layerIds) {
                this.layerIds.add(e);
            }
        }

        public DescribeElasticLoadBalancersRequest build() {
            return new DescribeElasticLoadBalancersRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeElasticLoadBalancersRequest> {
        public Builder stackId(String var1);

        public Builder layerIds(Collection<String> var1);

        public Builder layerIds(String ... var1);
    }
}

