/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.opsworks.transform.WeeklyAutoScalingScheduleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a time-based instance's auto scaling schedule. The schedule consists of a set of key-value pairs.
 * </p>
 * <ul>
 * <li>
 * <p>
 * The key is the time period (a UTC hour) and must be an integer from 0 - 23.
 * </p>
 * </li>
 * <li>
 * <p>
 * The value indicates whether the instance should be online or offline for the specified period, and must be set to
 * "on" or "off"
 * </p>
 * </li>
 * </ul>
 * <p>
 * The default setting for all time periods is off, so you use the following parameters primarily to specify the online
 * periods. You don't have to explicitly specify offline periods unless you want to change an online period to an
 * offline period.
 * </p>
 * <p>
 * The following example specifies that the instance should be online for four hours, from UTC 1200 - 1600. It will be
 * off for the remainder of the day.
 * </p>
 * <p>
 * <code> { "12":"on", "13":"on", "14":"on", "15":"on" } </code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class WeeklyAutoScalingSchedule implements StructuredPojo,
        ToCopyableBuilder<WeeklyAutoScalingSchedule.Builder, WeeklyAutoScalingSchedule> {
    private final Map<String, String> monday;

    private final Map<String, String> tuesday;

    private final Map<String, String> wednesday;

    private final Map<String, String> thursday;

    private final Map<String, String> friday;

    private final Map<String, String> saturday;

    private final Map<String, String> sunday;

    private WeeklyAutoScalingSchedule(BuilderImpl builder) {
        this.monday = builder.monday;
        this.tuesday = builder.tuesday;
        this.wednesday = builder.wednesday;
        this.thursday = builder.thursday;
        this.friday = builder.friday;
        this.saturday = builder.saturday;
        this.sunday = builder.sunday;
    }

    /**
     * <p>
     * The schedule for Monday.
     * </p>
     * 
     * @return The schedule for Monday.
     */
    public Map<String, String> monday() {
        return monday;
    }

    /**
     * <p>
     * The schedule for Tuesday.
     * </p>
     * 
     * @return The schedule for Tuesday.
     */
    public Map<String, String> tuesday() {
        return tuesday;
    }

    /**
     * <p>
     * The schedule for Wednesday.
     * </p>
     * 
     * @return The schedule for Wednesday.
     */
    public Map<String, String> wednesday() {
        return wednesday;
    }

    /**
     * <p>
     * The schedule for Thursday.
     * </p>
     * 
     * @return The schedule for Thursday.
     */
    public Map<String, String> thursday() {
        return thursday;
    }

    /**
     * <p>
     * The schedule for Friday.
     * </p>
     * 
     * @return The schedule for Friday.
     */
    public Map<String, String> friday() {
        return friday;
    }

    /**
     * <p>
     * The schedule for Saturday.
     * </p>
     * 
     * @return The schedule for Saturday.
     */
    public Map<String, String> saturday() {
        return saturday;
    }

    /**
     * <p>
     * The schedule for Sunday.
     * </p>
     * 
     * @return The schedule for Sunday.
     */
    public Map<String, String> sunday() {
        return sunday;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((monday() == null) ? 0 : monday().hashCode());
        hashCode = 31 * hashCode + ((tuesday() == null) ? 0 : tuesday().hashCode());
        hashCode = 31 * hashCode + ((wednesday() == null) ? 0 : wednesday().hashCode());
        hashCode = 31 * hashCode + ((thursday() == null) ? 0 : thursday().hashCode());
        hashCode = 31 * hashCode + ((friday() == null) ? 0 : friday().hashCode());
        hashCode = 31 * hashCode + ((saturday() == null) ? 0 : saturday().hashCode());
        hashCode = 31 * hashCode + ((sunday() == null) ? 0 : sunday().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeeklyAutoScalingSchedule)) {
            return false;
        }
        WeeklyAutoScalingSchedule other = (WeeklyAutoScalingSchedule) obj;
        if (other.monday() == null ^ this.monday() == null) {
            return false;
        }
        if (other.monday() != null && !other.monday().equals(this.monday())) {
            return false;
        }
        if (other.tuesday() == null ^ this.tuesday() == null) {
            return false;
        }
        if (other.tuesday() != null && !other.tuesday().equals(this.tuesday())) {
            return false;
        }
        if (other.wednesday() == null ^ this.wednesday() == null) {
            return false;
        }
        if (other.wednesday() != null && !other.wednesday().equals(this.wednesday())) {
            return false;
        }
        if (other.thursday() == null ^ this.thursday() == null) {
            return false;
        }
        if (other.thursday() != null && !other.thursday().equals(this.thursday())) {
            return false;
        }
        if (other.friday() == null ^ this.friday() == null) {
            return false;
        }
        if (other.friday() != null && !other.friday().equals(this.friday())) {
            return false;
        }
        if (other.saturday() == null ^ this.saturday() == null) {
            return false;
        }
        if (other.saturday() != null && !other.saturday().equals(this.saturday())) {
            return false;
        }
        if (other.sunday() == null ^ this.sunday() == null) {
            return false;
        }
        if (other.sunday() != null && !other.sunday().equals(this.sunday())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (monday() != null) {
            sb.append("Monday: ").append(monday()).append(",");
        }
        if (tuesday() != null) {
            sb.append("Tuesday: ").append(tuesday()).append(",");
        }
        if (wednesday() != null) {
            sb.append("Wednesday: ").append(wednesday()).append(",");
        }
        if (thursday() != null) {
            sb.append("Thursday: ").append(thursday()).append(",");
        }
        if (friday() != null) {
            sb.append("Friday: ").append(friday()).append(",");
        }
        if (saturday() != null) {
            sb.append("Saturday: ").append(saturday()).append(",");
        }
        if (sunday() != null) {
            sb.append("Sunday: ").append(sunday()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WeeklyAutoScalingScheduleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WeeklyAutoScalingSchedule> {
        /**
         * <p>
         * The schedule for Monday.
         * </p>
         * 
         * @param monday
         *        The schedule for Monday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monday(Map<String, String> monday);

        /**
         * <p>
         * The schedule for Tuesday.
         * </p>
         * 
         * @param tuesday
         *        The schedule for Tuesday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tuesday(Map<String, String> tuesday);

        /**
         * <p>
         * The schedule for Wednesday.
         * </p>
         * 
         * @param wednesday
         *        The schedule for Wednesday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wednesday(Map<String, String> wednesday);

        /**
         * <p>
         * The schedule for Thursday.
         * </p>
         * 
         * @param thursday
         *        The schedule for Thursday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thursday(Map<String, String> thursday);

        /**
         * <p>
         * The schedule for Friday.
         * </p>
         * 
         * @param friday
         *        The schedule for Friday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder friday(Map<String, String> friday);

        /**
         * <p>
         * The schedule for Saturday.
         * </p>
         * 
         * @param saturday
         *        The schedule for Saturday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder saturday(Map<String, String> saturday);

        /**
         * <p>
         * The schedule for Sunday.
         * </p>
         * 
         * @param sunday
         *        The schedule for Sunday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sunday(Map<String, String> sunday);
    }

    private static final class BuilderImpl implements Builder {
        private Map<String, String> monday = new SdkInternalMap<>();

        private Map<String, String> tuesday = new SdkInternalMap<>();

        private Map<String, String> wednesday = new SdkInternalMap<>();

        private Map<String, String> thursday = new SdkInternalMap<>();

        private Map<String, String> friday = new SdkInternalMap<>();

        private Map<String, String> saturday = new SdkInternalMap<>();

        private Map<String, String> sunday = new SdkInternalMap<>();

        private BuilderImpl() {
        }

        private BuilderImpl(WeeklyAutoScalingSchedule model) {
            setMonday(model.monday);
            setTuesday(model.tuesday);
            setWednesday(model.wednesday);
            setThursday(model.thursday);
            setFriday(model.friday);
            setSaturday(model.saturday);
            setSunday(model.sunday);
        }

        public final Map<String, String> getMonday() {
            return monday;
        }

        @Override
        public final Builder monday(Map<String, String> monday) {
            this.monday = DailyAutoScalingScheduleCopier.copy(monday);
            return this;
        }

        public final void setMonday(Map<String, String> monday) {
            this.monday = DailyAutoScalingScheduleCopier.copy(monday);
        }

        public final Map<String, String> getTuesday() {
            return tuesday;
        }

        @Override
        public final Builder tuesday(Map<String, String> tuesday) {
            this.tuesday = DailyAutoScalingScheduleCopier.copy(tuesday);
            return this;
        }

        public final void setTuesday(Map<String, String> tuesday) {
            this.tuesday = DailyAutoScalingScheduleCopier.copy(tuesday);
        }

        public final Map<String, String> getWednesday() {
            return wednesday;
        }

        @Override
        public final Builder wednesday(Map<String, String> wednesday) {
            this.wednesday = DailyAutoScalingScheduleCopier.copy(wednesday);
            return this;
        }

        public final void setWednesday(Map<String, String> wednesday) {
            this.wednesday = DailyAutoScalingScheduleCopier.copy(wednesday);
        }

        public final Map<String, String> getThursday() {
            return thursday;
        }

        @Override
        public final Builder thursday(Map<String, String> thursday) {
            this.thursday = DailyAutoScalingScheduleCopier.copy(thursday);
            return this;
        }

        public final void setThursday(Map<String, String> thursday) {
            this.thursday = DailyAutoScalingScheduleCopier.copy(thursday);
        }

        public final Map<String, String> getFriday() {
            return friday;
        }

        @Override
        public final Builder friday(Map<String, String> friday) {
            this.friday = DailyAutoScalingScheduleCopier.copy(friday);
            return this;
        }

        public final void setFriday(Map<String, String> friday) {
            this.friday = DailyAutoScalingScheduleCopier.copy(friday);
        }

        public final Map<String, String> getSaturday() {
            return saturday;
        }

        @Override
        public final Builder saturday(Map<String, String> saturday) {
            this.saturday = DailyAutoScalingScheduleCopier.copy(saturday);
            return this;
        }

        public final void setSaturday(Map<String, String> saturday) {
            this.saturday = DailyAutoScalingScheduleCopier.copy(saturday);
        }

        public final Map<String, String> getSunday() {
            return sunday;
        }

        @Override
        public final Builder sunday(Map<String, String> sunday) {
            this.sunday = DailyAutoScalingScheduleCopier.copy(sunday);
            return this;
        }

        public final void setSunday(Map<String, String> sunday) {
            this.sunday = DailyAutoScalingScheduleCopier.copy(sunday);
        }

        @Override
        public WeeklyAutoScalingSchedule build() {
            return new WeeklyAutoScalingSchedule(this);
        }
    }
}
