/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateRdsDbInstanceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateRdsDbInstanceRequest.Builder, UpdateRdsDbInstanceRequest> {
    private final String rdsDbInstanceArn;

    private final String dbUser;

    private final String dbPassword;

    private UpdateRdsDbInstanceRequest(BuilderImpl builder) {
        this.rdsDbInstanceArn = builder.rdsDbInstanceArn;
        this.dbUser = builder.dbUser;
        this.dbPassword = builder.dbPassword;
    }

    /**
     * <p>
     * The Amazon RDS instance's ARN.
     * </p>
     * 
     * @return The Amazon RDS instance's ARN.
     */
    public String rdsDbInstanceArn() {
        return rdsDbInstanceArn;
    }

    /**
     * <p>
     * The master user name.
     * </p>
     * 
     * @return The master user name.
     */
    public String dbUser() {
        return dbUser;
    }

    /**
     * <p>
     * The database password.
     * </p>
     * 
     * @return The database password.
     */
    public String dbPassword() {
        return dbPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((rdsDbInstanceArn() == null) ? 0 : rdsDbInstanceArn().hashCode());
        hashCode = 31 * hashCode + ((dbUser() == null) ? 0 : dbUser().hashCode());
        hashCode = 31 * hashCode + ((dbPassword() == null) ? 0 : dbPassword().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRdsDbInstanceRequest)) {
            return false;
        }
        UpdateRdsDbInstanceRequest other = (UpdateRdsDbInstanceRequest) obj;
        if (other.rdsDbInstanceArn() == null ^ this.rdsDbInstanceArn() == null) {
            return false;
        }
        if (other.rdsDbInstanceArn() != null && !other.rdsDbInstanceArn().equals(this.rdsDbInstanceArn())) {
            return false;
        }
        if (other.dbUser() == null ^ this.dbUser() == null) {
            return false;
        }
        if (other.dbUser() != null && !other.dbUser().equals(this.dbUser())) {
            return false;
        }
        if (other.dbPassword() == null ^ this.dbPassword() == null) {
            return false;
        }
        if (other.dbPassword() != null && !other.dbPassword().equals(this.dbPassword())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (rdsDbInstanceArn() != null) {
            sb.append("RdsDbInstanceArn: ").append(rdsDbInstanceArn()).append(",");
        }
        if (dbUser() != null) {
            sb.append("DbUser: ").append(dbUser()).append(",");
        }
        if (dbPassword() != null) {
            sb.append("DbPassword: ").append(dbPassword()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateRdsDbInstanceRequest> {
        /**
         * <p>
         * The Amazon RDS instance's ARN.
         * </p>
         * 
         * @param rdsDbInstanceArn
         *        The Amazon RDS instance's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbInstanceArn(String rdsDbInstanceArn);

        /**
         * <p>
         * The master user name.
         * </p>
         * 
         * @param dbUser
         *        The master user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * The database password.
         * </p>
         * 
         * @param dbPassword
         *        The database password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbPassword(String dbPassword);
    }

    private static final class BuilderImpl implements Builder {
        private String rdsDbInstanceArn;

        private String dbUser;

        private String dbPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRdsDbInstanceRequest model) {
            setRdsDbInstanceArn(model.rdsDbInstanceArn);
            setDbUser(model.dbUser);
            setDbPassword(model.dbPassword);
        }

        public final String getRdsDbInstanceArn() {
            return rdsDbInstanceArn;
        }

        @Override
        public final Builder rdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
            return this;
        }

        public final void setRdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
        }

        public final String getDbUser() {
            return dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final String getDbPassword() {
            return dbPassword;
        }

        @Override
        public final Builder dbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        public final void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        @Override
        public UpdateRdsDbInstanceRequest build() {
            return new UpdateRdsDbInstanceRequest(this);
        }
    }
}
