/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateInstanceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateInstanceRequest.Builder, UpdateInstanceRequest> {
    private final String instanceId;

    private final List<String> layerIds;

    private final String instanceType;

    private final String autoScalingType;

    private final String hostname;

    private final String os;

    private final String amiId;

    private final String sshKeyName;

    private final String architecture;

    private final Boolean installUpdatesOnBoot;

    private final Boolean ebsOptimized;

    private final String agentVersion;

    private UpdateInstanceRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.layerIds = builder.layerIds;
        this.instanceType = builder.instanceType;
        this.autoScalingType = builder.autoScalingType;
        this.hostname = builder.hostname;
        this.os = builder.os;
        this.amiId = builder.amiId;
        this.sshKeyName = builder.sshKeyName;
        this.architecture = builder.architecture;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.ebsOptimized = builder.ebsOptimized;
        this.agentVersion = builder.agentVersion;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance's layer IDs.
     * </p>
     * 
     * @return The instance's layer IDs.
     */
    public List<String> layerIds() {
        return layerIds;
    }

    /**
     * <p>
     * The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack in the
     * console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the currently
     * supported types. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.
     * The parameter values that you use to specify the various types are in the <b>API Name</b> column of the
     * <b>Available Instance Types</b> table.
     * </p>
     * 
     * @return The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack
     *         in the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the
     *         currently supported types. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
     *         Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b>
     *         column of the <b>Available Instance Types</b> table.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
     * </p>
     * 
     * @return For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
     * @see AutoScalingType
     */
    public String autoScalingType() {
        return autoScalingType;
    }

    /**
     * <p>
     * The instance host name.
     * </p>
     * 
     * @return The instance host name.
     */
    public String hostname() {
        return hostname;
    }

    /**
     * <p>
     * The instance's operating system, which must be set to one of the following. You cannot update an instance that is
     * using a custom AMI.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2017.03</code>,
     * <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or
     * <code>Amazon Linux 2015.03</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or
     * <code>Ubuntu 12.04 LTS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CentOS Linux 7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Red Hat Enterprise Linux 7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on the supported operating systems, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks
     * Operating Systems</a>.
     * </p>
     * <p>
     * The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>, you
     * must use the AmiId parameter to specify the custom AMI that you want to use. For more information on the
     * supported operating systems, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">Operating Systems</a>. For
     * more information on how to use custom AMIs with OpsWorks, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom
     * AMIs</a>.
     * </p>
     * <note>
     * <p>
     * You can specify a different Linux operating system for the updated stack, but you cannot change from Linux to
     * Windows or Windows to Linux.
     * </p>
     * </note>
     * 
     * @return The instance's operating system, which must be set to one of the following. You cannot update an instance
     *         that is using a custom AMI.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2017.03</code>,
     *         <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>,
     *         or <code>Amazon Linux 2015.03</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>
     *         , or <code>Ubuntu 12.04 LTS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CentOS Linux 7</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Red Hat Enterprise Linux 7</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information on the supported operating systems, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks
     *         Operating Systems</a>.
     *         </p>
     *         <p>
     *         The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>,
     *         you must use the AmiId parameter to specify the custom AMI that you want to use. For more information on
     *         the supported operating systems, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">Operating
     *         Systems</a>. For more information on how to use custom AMIs with OpsWorks, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom
     *         AMIs</a>.
     *         </p>
     *         <note>
     *         <p>
     *         You can specify a different Linux operating system for the updated stack, but you cannot change from
     *         Linux to Windows or Windows to Linux.
     *         </p>
     */
    public String os() {
        return os;
    }

    /**
     * <p>
     * The ID of the AMI that was used to create the instance. The value of this parameter must be the same AMI ID that
     * the instance is already using. You cannot apply a new AMI to an instance by running UpdateInstance.
     * UpdateInstance does not work on instances that are using custom AMIs.
     * </p>
     * 
     * @return The ID of the AMI that was used to create the instance. The value of this parameter must be the same AMI
     *         ID that the instance is already using. You cannot apply a new AMI to an instance by running
     *         UpdateInstance. UpdateInstance does not work on instances that are using custom AMIs.
     */
    public String amiId() {
        return amiId;
    }

    /**
     * <p>
     * The instance's Amazon EC2 key name.
     * </p>
     * 
     * @return The instance's Amazon EC2 key name.
     */
    public String sshKeyName() {
        return sshKeyName;
    }

    /**
     * <p>
     * The instance architecture. Instance types do not necessarily support both architectures. For a list of the
     * architectures that are supported by the different instance types, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.
     * </p>
     * 
     * @return The instance architecture. Instance types do not necessarily support both architectures. For a list of
     *         the architectures that are supported by the different instance types, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
     *         Types</a>.
     * @see Architecture
     */
    public String architecture() {
        return architecture;
    }

    /**
     * <p>
     * Whether to install operating system and package updates when the instance boots. The default value is
     * <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then
     * update your instances manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack
     * command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
     * </p>
     * <note>
     * <p>
     * We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest
     * security updates.
     * </p>
     * </note>
     * 
     * @return Whether to install operating system and package updates when the instance boots. The default value is
     *         <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must
     *         then update your instances manually by using <a>CreateDeployment</a> to run the
     *         <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or
     *         <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
     *         <p>
     *         We strongly recommend using the default value of <code>true</code>, to ensure that your instances have
     *         the latest security updates.
     *         </p>
     */
    public Boolean installUpdatesOnBoot() {
        return installUpdatesOnBoot;
    }

    /**
     * <p>
     * This property cannot be updated.
     * </p>
     * 
     * @return This property cannot be updated.
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The default AWS OpsWorks Stacks agent version. You have the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INHERIT</code> - Use the stack's default agent version setting.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>version_number</i> - Use the specified agent version. This value overrides the stack's default setting. To
     * update the agent version, you must edit the instance configuration and specify a new version. AWS OpsWorks Stacks
     * then automatically installs that version on the instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete version
     * number, not the abbreviated number shown on the console. For a list of available agent version numbers, call
     * <a>DescribeAgentVersions</a>.
     * </p>
     * <p>
     * AgentVersion cannot be set to Chef 12.2.
     * </p>
     * 
     * @return The default AWS OpsWorks Stacks agent version. You have the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INHERIT</code> - Use the stack's default agent version setting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>version_number</i> - Use the specified agent version. This value overrides the stack's default
     *         setting. To update the agent version, you must edit the instance configuration and specify a new version.
     *         AWS OpsWorks Stacks then automatically installs that version on the instance.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete
     *         version number, not the abbreviated number shown on the console. For a list of available agent version
     *         numbers, call <a>DescribeAgentVersions</a>.
     *         </p>
     *         <p>
     *         AgentVersion cannot be set to Chef 12.2.
     */
    public String agentVersion() {
        return agentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((layerIds() == null) ? 0 : layerIds().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((autoScalingType() == null) ? 0 : autoScalingType().hashCode());
        hashCode = 31 * hashCode + ((hostname() == null) ? 0 : hostname().hashCode());
        hashCode = 31 * hashCode + ((os() == null) ? 0 : os().hashCode());
        hashCode = 31 * hashCode + ((amiId() == null) ? 0 : amiId().hashCode());
        hashCode = 31 * hashCode + ((sshKeyName() == null) ? 0 : sshKeyName().hashCode());
        hashCode = 31 * hashCode + ((architecture() == null) ? 0 : architecture().hashCode());
        hashCode = 31 * hashCode + ((installUpdatesOnBoot() == null) ? 0 : installUpdatesOnBoot().hashCode());
        hashCode = 31 * hashCode + ((ebsOptimized() == null) ? 0 : ebsOptimized().hashCode());
        hashCode = 31 * hashCode + ((agentVersion() == null) ? 0 : agentVersion().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstanceRequest)) {
            return false;
        }
        UpdateInstanceRequest other = (UpdateInstanceRequest) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.layerIds() == null ^ this.layerIds() == null) {
            return false;
        }
        if (other.layerIds() != null && !other.layerIds().equals(this.layerIds())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.autoScalingType() == null ^ this.autoScalingType() == null) {
            return false;
        }
        if (other.autoScalingType() != null && !other.autoScalingType().equals(this.autoScalingType())) {
            return false;
        }
        if (other.hostname() == null ^ this.hostname() == null) {
            return false;
        }
        if (other.hostname() != null && !other.hostname().equals(this.hostname())) {
            return false;
        }
        if (other.os() == null ^ this.os() == null) {
            return false;
        }
        if (other.os() != null && !other.os().equals(this.os())) {
            return false;
        }
        if (other.amiId() == null ^ this.amiId() == null) {
            return false;
        }
        if (other.amiId() != null && !other.amiId().equals(this.amiId())) {
            return false;
        }
        if (other.sshKeyName() == null ^ this.sshKeyName() == null) {
            return false;
        }
        if (other.sshKeyName() != null && !other.sshKeyName().equals(this.sshKeyName())) {
            return false;
        }
        if (other.architecture() == null ^ this.architecture() == null) {
            return false;
        }
        if (other.architecture() != null && !other.architecture().equals(this.architecture())) {
            return false;
        }
        if (other.installUpdatesOnBoot() == null ^ this.installUpdatesOnBoot() == null) {
            return false;
        }
        if (other.installUpdatesOnBoot() != null && !other.installUpdatesOnBoot().equals(this.installUpdatesOnBoot())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.agentVersion() == null ^ this.agentVersion() == null) {
            return false;
        }
        if (other.agentVersion() != null && !other.agentVersion().equals(this.agentVersion())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (layerIds() != null) {
            sb.append("LayerIds: ").append(layerIds()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (autoScalingType() != null) {
            sb.append("AutoScalingType: ").append(autoScalingType()).append(",");
        }
        if (hostname() != null) {
            sb.append("Hostname: ").append(hostname()).append(",");
        }
        if (os() != null) {
            sb.append("Os: ").append(os()).append(",");
        }
        if (amiId() != null) {
            sb.append("AmiId: ").append(amiId()).append(",");
        }
        if (sshKeyName() != null) {
            sb.append("SshKeyName: ").append(sshKeyName()).append(",");
        }
        if (architecture() != null) {
            sb.append("Architecture: ").append(architecture()).append(",");
        }
        if (installUpdatesOnBoot() != null) {
            sb.append("InstallUpdatesOnBoot: ").append(installUpdatesOnBoot()).append(",");
        }
        if (ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(ebsOptimized()).append(",");
        }
        if (agentVersion() != null) {
            sb.append("AgentVersion: ").append(agentVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateInstanceRequest> {
        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance's layer IDs.
         * </p>
         * 
         * @param layerIds
         *        The instance's layer IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(Collection<String> layerIds);

        /**
         * <p>
         * The instance's layer IDs.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setLayerIds(java.util.Collection)} or {@link #withLayerIds(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param layerIds
         *        The instance's layer IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(String... layerIds);

        /**
         * <p>
         * The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack in
         * the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the
         * currently supported types. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
         * Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b> column
         * of the <b>Available Instance Types</b> table.
         * </p>
         * 
         * @param instanceType
         *        The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the
         *        stack in the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list
         *        contains the currently supported types. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
         *        Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b>
         *        column of the <b>Available Instance Types</b> table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
         * </p>
         * 
         * @param autoScalingType
         *        For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingType
         */
        Builder autoScalingType(String autoScalingType);

        /**
         * <p>
         * For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
         * </p>
         * 
         * @param autoScalingType
         *        For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingType
         */
        Builder autoScalingType(AutoScalingType autoScalingType);

        /**
         * <p>
         * The instance host name.
         * </p>
         * 
         * @param hostname
         *        The instance host name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * The instance's operating system, which must be set to one of the following. You cannot update an instance
         * that is using a custom AMI.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2017.03</code>,
         * <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or
         * <code>Amazon Linux 2015.03</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or
         * <code>Ubuntu 12.04 LTS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CentOS Linux 7</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Red Hat Enterprise Linux 7</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information on the supported operating systems, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks
         * Operating Systems</a>.
         * </p>
         * <p>
         * The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>, you
         * must use the AmiId parameter to specify the custom AMI that you want to use. For more information on the
         * supported operating systems, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">Operating Systems</a>.
         * For more information on how to use custom AMIs with OpsWorks, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom
         * AMIs</a>.
         * </p>
         * <note>
         * <p>
         * You can specify a different Linux operating system for the updated stack, but you cannot change from Linux to
         * Windows or Windows to Linux.
         * </p>
         * </note>
         * 
         * @param os
         *        The instance's operating system, which must be set to one of the following. You cannot update an
         *        instance that is using a custom AMI.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>,
         *        <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>,
         *        <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CentOS Linux 7</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Red Hat Enterprise Linux 7</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information on the supported operating systems, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks
         *        Stacks Operating Systems</a>.
         *        </p>
         *        <p>
         *        The default option is the current Amazon Linux version. If you set this parameter to
         *        <code>Custom</code>, you must use the AmiId parameter to specify the custom AMI that you want to use.
         *        For more information on the supported operating systems, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">Operating
         *        Systems</a>. For more information on how to use custom AMIs with OpsWorks, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using
         *        Custom AMIs</a>.
         *        </p>
         *        <note>
         *        <p>
         *        You can specify a different Linux operating system for the updated stack, but you cannot change from
         *        Linux to Windows or Windows to Linux.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder os(String os);

        /**
         * <p>
         * The ID of the AMI that was used to create the instance. The value of this parameter must be the same AMI ID
         * that the instance is already using. You cannot apply a new AMI to an instance by running UpdateInstance.
         * UpdateInstance does not work on instances that are using custom AMIs.
         * </p>
         * 
         * @param amiId
         *        The ID of the AMI that was used to create the instance. The value of this parameter must be the same
         *        AMI ID that the instance is already using. You cannot apply a new AMI to an instance by running
         *        UpdateInstance. UpdateInstance does not work on instances that are using custom AMIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiId(String amiId);

        /**
         * <p>
         * The instance's Amazon EC2 key name.
         * </p>
         * 
         * @param sshKeyName
         *        The instance's Amazon EC2 key name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshKeyName(String sshKeyName);

        /**
         * <p>
         * The instance architecture. Instance types do not necessarily support both architectures. For a list of the
         * architectures that are supported by the different instance types, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
         * Types</a>.
         * </p>
         * 
         * @param architecture
         *        The instance architecture. Instance types do not necessarily support both architectures. For a list of
         *        the architectures that are supported by the different instance types, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
         *        Types</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The instance architecture. Instance types do not necessarily support both architectures. For a list of the
         * architectures that are supported by the different instance types, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
         * Types</a>.
         * </p>
         * 
         * @param architecture
         *        The instance architecture. Instance types do not necessarily support both architectures. For a list of
         *        the architectures that are supported by the different instance types, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
         *        Types</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(Architecture architecture);

        /**
         * <p>
         * Whether to install operating system and package updates when the instance boots. The default value is
         * <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then
         * update your instances manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code>
         * stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the
         * instances.
         * </p>
         * <note>
         * <p>
         * We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the
         * latest security updates.
         * </p>
         * </note>
         * 
         * @param installUpdatesOnBoot
         *        Whether to install operating system and package updates when the instance boots. The default value is
         *        <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You
         *        must then update your instances manually by using <a>CreateDeployment</a> to run the
         *        <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux)
         *        or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
         *        <p>
         *        We strongly recommend using the default value of <code>true</code>, to ensure that your instances have
         *        the latest security updates.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot);

        /**
         * <p>
         * This property cannot be updated.
         * </p>
         * 
         * @param ebsOptimized
         *        This property cannot be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The default AWS OpsWorks Stacks agent version. You have the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INHERIT</code> - Use the stack's default agent version setting.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>version_number</i> - Use the specified agent version. This value overrides the stack's default setting. To
         * update the agent version, you must edit the instance configuration and specify a new version. AWS OpsWorks
         * Stacks then automatically installs that version on the instance.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete version
         * number, not the abbreviated number shown on the console. For a list of available agent version numbers, call
         * <a>DescribeAgentVersions</a>.
         * </p>
         * <p>
         * AgentVersion cannot be set to Chef 12.2.
         * </p>
         * 
         * @param agentVersion
         *        The default AWS OpsWorks Stacks agent version. You have the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INHERIT</code> - Use the stack's default agent version setting.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>version_number</i> - Use the specified agent version. This value overrides the stack's default
         *        setting. To update the agent version, you must edit the instance configuration and specify a new
         *        version. AWS OpsWorks Stacks then automatically installs that version on the instance.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete
         *        version number, not the abbreviated number shown on the console. For a list of available agent version
         *        numbers, call <a>DescribeAgentVersions</a>.
         *        </p>
         *        <p>
         *        AgentVersion cannot be set to Chef 12.2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceId;

        private List<String> layerIds = new SdkInternalList<>();

        private String instanceType;

        private String autoScalingType;

        private String hostname;

        private String os;

        private String amiId;

        private String sshKeyName;

        private String architecture;

        private Boolean installUpdatesOnBoot;

        private Boolean ebsOptimized;

        private String agentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInstanceRequest model) {
            setInstanceId(model.instanceId);
            setLayerIds(model.layerIds);
            setInstanceType(model.instanceType);
            setAutoScalingType(model.autoScalingType);
            setHostname(model.hostname);
            setOs(model.os);
            setAmiId(model.amiId);
            setSshKeyName(model.sshKeyName);
            setArchitecture(model.architecture);
            setInstallUpdatesOnBoot(model.installUpdatesOnBoot);
            setEbsOptimized(model.ebsOptimized);
            setAgentVersion(model.agentVersion);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<String> getLayerIds() {
            return layerIds;
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String... layerIds) {
            if (this.layerIds == null) {
                this.layerIds = new SdkInternalList<>(layerIds.length);
            }
            for (String e : layerIds) {
                this.layerIds.add(e);
            }
            return this;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        @SafeVarargs
        public final void setLayerIds(String... layerIds) {
            if (this.layerIds == null) {
                this.layerIds = new SdkInternalList<>(layerIds.length);
            }
            for (String e : layerIds) {
                this.layerIds.add(e);
            }
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getAutoScalingType() {
            return autoScalingType;
        }

        @Override
        public final Builder autoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
            return this;
        }

        @Override
        public final Builder autoScalingType(AutoScalingType autoScalingType) {
            this.autoScalingType(autoScalingType.toString());
            return this;
        }

        public final void setAutoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
        }

        public final void setAutoScalingType(AutoScalingType autoScalingType) {
            this.autoScalingType(autoScalingType.toString());
        }

        public final String getHostname() {
            return hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getOs() {
            return os;
        }

        @Override
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        public final String getAmiId() {
            return amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final String getSshKeyName() {
            return sshKeyName;
        }

        @Override
        public final Builder sshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        public final void setSshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
        }

        public final String getArchitecture() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final void setArchitecture(Architecture architecture) {
            this.architecture(architecture.toString());
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public UpdateInstanceRequest build() {
            return new UpdateInstanceRequest(this);
        }
    }
}
