/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.opsworks.transform.RecipesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * AWS OpsWorks Stacks supports five lifecycle events: <b>setup</b>, <b>configuration</b>, <b>deploy</b>,
 * <b>undeploy</b>, and <b>shutdown</b>. For each layer, AWS OpsWorks Stacks runs a set of standard recipes for each
 * event. In addition, you can provide custom recipes for any or all layers and events. AWS OpsWorks Stacks runs custom
 * event recipes after the standard recipes. <code>LayerCustomRecipes</code> specifies the custom recipes for a
 * particular layer to be run in response to each of the five events.
 * </p>
 * <p>
 * To specify a recipe, use the cookbook's directory name in the repository followed by two colons and the recipe name,
 * which is the recipe's file name without the .rb extension. For example: phpapp2::dbsetup specifies the dbsetup.rb
 * recipe in the repository's phpapp2 folder.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Recipes implements StructuredPojo, ToCopyableBuilder<Recipes.Builder, Recipes> {
    private final List<String> setup;

    private final List<String> configure;

    private final List<String> deploy;

    private final List<String> undeploy;

    private final List<String> shutdown;

    private Recipes(BuilderImpl builder) {
        this.setup = builder.setup;
        this.configure = builder.configure;
        this.deploy = builder.deploy;
        this.undeploy = builder.undeploy;
        this.shutdown = builder.shutdown;
    }

    /**
     * <p>
     * An array of custom recipe names to be run following a <code>setup</code> event.
     * </p>
     * 
     * @return An array of custom recipe names to be run following a <code>setup</code> event.
     */
    public List<String> setup() {
        return setup;
    }

    /**
     * <p>
     * An array of custom recipe names to be run following a <code>configure</code> event.
     * </p>
     * 
     * @return An array of custom recipe names to be run following a <code>configure</code> event.
     */
    public List<String> configure() {
        return configure;
    }

    /**
     * <p>
     * An array of custom recipe names to be run following a <code>deploy</code> event.
     * </p>
     * 
     * @return An array of custom recipe names to be run following a <code>deploy</code> event.
     */
    public List<String> deploy() {
        return deploy;
    }

    /**
     * <p>
     * An array of custom recipe names to be run following a <code>undeploy</code> event.
     * </p>
     * 
     * @return An array of custom recipe names to be run following a <code>undeploy</code> event.
     */
    public List<String> undeploy() {
        return undeploy;
    }

    /**
     * <p>
     * An array of custom recipe names to be run following a <code>shutdown</code> event.
     * </p>
     * 
     * @return An array of custom recipe names to be run following a <code>shutdown</code> event.
     */
    public List<String> shutdown() {
        return shutdown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((setup() == null) ? 0 : setup().hashCode());
        hashCode = 31 * hashCode + ((configure() == null) ? 0 : configure().hashCode());
        hashCode = 31 * hashCode + ((deploy() == null) ? 0 : deploy().hashCode());
        hashCode = 31 * hashCode + ((undeploy() == null) ? 0 : undeploy().hashCode());
        hashCode = 31 * hashCode + ((shutdown() == null) ? 0 : shutdown().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recipes)) {
            return false;
        }
        Recipes other = (Recipes) obj;
        if (other.setup() == null ^ this.setup() == null) {
            return false;
        }
        if (other.setup() != null && !other.setup().equals(this.setup())) {
            return false;
        }
        if (other.configure() == null ^ this.configure() == null) {
            return false;
        }
        if (other.configure() != null && !other.configure().equals(this.configure())) {
            return false;
        }
        if (other.deploy() == null ^ this.deploy() == null) {
            return false;
        }
        if (other.deploy() != null && !other.deploy().equals(this.deploy())) {
            return false;
        }
        if (other.undeploy() == null ^ this.undeploy() == null) {
            return false;
        }
        if (other.undeploy() != null && !other.undeploy().equals(this.undeploy())) {
            return false;
        }
        if (other.shutdown() == null ^ this.shutdown() == null) {
            return false;
        }
        if (other.shutdown() != null && !other.shutdown().equals(this.shutdown())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (setup() != null) {
            sb.append("Setup: ").append(setup()).append(",");
        }
        if (configure() != null) {
            sb.append("Configure: ").append(configure()).append(",");
        }
        if (deploy() != null) {
            sb.append("Deploy: ").append(deploy()).append(",");
        }
        if (undeploy() != null) {
            sb.append("Undeploy: ").append(undeploy()).append(",");
        }
        if (shutdown() != null) {
            sb.append("Shutdown: ").append(shutdown()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecipesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Recipes> {
        /**
         * <p>
         * An array of custom recipe names to be run following a <code>setup</code> event.
         * </p>
         * 
         * @param setup
         *        An array of custom recipe names to be run following a <code>setup</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setup(Collection<String> setup);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>setup</code> event.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setSetup(java.util.Collection)} or {@link #withSetup(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param setup
         *        An array of custom recipe names to be run following a <code>setup</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setup(String... setup);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>configure</code> event.
         * </p>
         * 
         * @param configure
         *        An array of custom recipe names to be run following a <code>configure</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configure(Collection<String> configure);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>configure</code> event.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setConfigure(java.util.Collection)} or {@link #withConfigure(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param configure
         *        An array of custom recipe names to be run following a <code>configure</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configure(String... configure);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>deploy</code> event.
         * </p>
         * 
         * @param deploy
         *        An array of custom recipe names to be run following a <code>deploy</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploy(Collection<String> deploy);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>deploy</code> event.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDeploy(java.util.Collection)} or {@link #withDeploy(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param deploy
         *        An array of custom recipe names to be run following a <code>deploy</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploy(String... deploy);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>undeploy</code> event.
         * </p>
         * 
         * @param undeploy
         *        An array of custom recipe names to be run following a <code>undeploy</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder undeploy(Collection<String> undeploy);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>undeploy</code> event.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setUndeploy(java.util.Collection)} or {@link #withUndeploy(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param undeploy
         *        An array of custom recipe names to be run following a <code>undeploy</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder undeploy(String... undeploy);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>shutdown</code> event.
         * </p>
         * 
         * @param shutdown
         *        An array of custom recipe names to be run following a <code>shutdown</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shutdown(Collection<String> shutdown);

        /**
         * <p>
         * An array of custom recipe names to be run following a <code>shutdown</code> event.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setShutdown(java.util.Collection)} or {@link #withShutdown(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param shutdown
         *        An array of custom recipe names to be run following a <code>shutdown</code> event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shutdown(String... shutdown);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> setup = new SdkInternalList<>();

        private List<String> configure = new SdkInternalList<>();

        private List<String> deploy = new SdkInternalList<>();

        private List<String> undeploy = new SdkInternalList<>();

        private List<String> shutdown = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(Recipes model) {
            setSetup(model.setup);
            setConfigure(model.configure);
            setDeploy(model.deploy);
            setUndeploy(model.undeploy);
            setShutdown(model.shutdown);
        }

        public final Collection<String> getSetup() {
            return setup;
        }

        @Override
        public final Builder setup(Collection<String> setup) {
            this.setup = StringsCopier.copy(setup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder setup(String... setup) {
            if (this.setup == null) {
                this.setup = new SdkInternalList<>(setup.length);
            }
            for (String e : setup) {
                this.setup.add(e);
            }
            return this;
        }

        public final void setSetup(Collection<String> setup) {
            this.setup = StringsCopier.copy(setup);
        }

        @SafeVarargs
        public final void setSetup(String... setup) {
            if (this.setup == null) {
                this.setup = new SdkInternalList<>(setup.length);
            }
            for (String e : setup) {
                this.setup.add(e);
            }
        }

        public final Collection<String> getConfigure() {
            return configure;
        }

        @Override
        public final Builder configure(Collection<String> configure) {
            this.configure = StringsCopier.copy(configure);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configure(String... configure) {
            if (this.configure == null) {
                this.configure = new SdkInternalList<>(configure.length);
            }
            for (String e : configure) {
                this.configure.add(e);
            }
            return this;
        }

        public final void setConfigure(Collection<String> configure) {
            this.configure = StringsCopier.copy(configure);
        }

        @SafeVarargs
        public final void setConfigure(String... configure) {
            if (this.configure == null) {
                this.configure = new SdkInternalList<>(configure.length);
            }
            for (String e : configure) {
                this.configure.add(e);
            }
        }

        public final Collection<String> getDeploy() {
            return deploy;
        }

        @Override
        public final Builder deploy(Collection<String> deploy) {
            this.deploy = StringsCopier.copy(deploy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploy(String... deploy) {
            if (this.deploy == null) {
                this.deploy = new SdkInternalList<>(deploy.length);
            }
            for (String e : deploy) {
                this.deploy.add(e);
            }
            return this;
        }

        public final void setDeploy(Collection<String> deploy) {
            this.deploy = StringsCopier.copy(deploy);
        }

        @SafeVarargs
        public final void setDeploy(String... deploy) {
            if (this.deploy == null) {
                this.deploy = new SdkInternalList<>(deploy.length);
            }
            for (String e : deploy) {
                this.deploy.add(e);
            }
        }

        public final Collection<String> getUndeploy() {
            return undeploy;
        }

        @Override
        public final Builder undeploy(Collection<String> undeploy) {
            this.undeploy = StringsCopier.copy(undeploy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder undeploy(String... undeploy) {
            if (this.undeploy == null) {
                this.undeploy = new SdkInternalList<>(undeploy.length);
            }
            for (String e : undeploy) {
                this.undeploy.add(e);
            }
            return this;
        }

        public final void setUndeploy(Collection<String> undeploy) {
            this.undeploy = StringsCopier.copy(undeploy);
        }

        @SafeVarargs
        public final void setUndeploy(String... undeploy) {
            if (this.undeploy == null) {
                this.undeploy = new SdkInternalList<>(undeploy.length);
            }
            for (String e : undeploy) {
                this.undeploy.add(e);
            }
        }

        public final Collection<String> getShutdown() {
            return shutdown;
        }

        @Override
        public final Builder shutdown(Collection<String> shutdown) {
            this.shutdown = StringsCopier.copy(shutdown);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shutdown(String... shutdown) {
            if (this.shutdown == null) {
                this.shutdown = new SdkInternalList<>(shutdown.length);
            }
            for (String e : shutdown) {
                this.shutdown.add(e);
            }
            return this;
        }

        public final void setShutdown(Collection<String> shutdown) {
            this.shutdown = StringsCopier.copy(shutdown);
        }

        @SafeVarargs
        public final void setShutdown(String... shutdown) {
            if (this.shutdown == null) {
                this.shutdown = new SdkInternalList<>(shutdown.length);
            }
            for (String e : shutdown) {
                this.shutdown.add(e);
            }
        }

        @Override
        public Recipes build() {
            return new Recipes(this);
        }
    }
}
