/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DetachElasticLoadBalancerRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DetachElasticLoadBalancerRequest.Builder, DetachElasticLoadBalancerRequest> {
    private final String elasticLoadBalancerName;

    private final String layerId;

    private DetachElasticLoadBalancerRequest(BuilderImpl builder) {
        this.elasticLoadBalancerName = builder.elasticLoadBalancerName;
        this.layerId = builder.layerId;
    }

    /**
     * <p>
     * The Elastic Load Balancing instance's name.
     * </p>
     * 
     * @return The Elastic Load Balancing instance's name.
     */
    public String elasticLoadBalancerName() {
        return elasticLoadBalancerName;
    }

    /**
     * <p>
     * The ID of the layer that the Elastic Load Balancing instance is attached to.
     * </p>
     * 
     * @return The ID of the layer that the Elastic Load Balancing instance is attached to.
     */
    public String layerId() {
        return layerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((elasticLoadBalancerName() == null) ? 0 : elasticLoadBalancerName().hashCode());
        hashCode = 31 * hashCode + ((layerId() == null) ? 0 : layerId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachElasticLoadBalancerRequest)) {
            return false;
        }
        DetachElasticLoadBalancerRequest other = (DetachElasticLoadBalancerRequest) obj;
        if (other.elasticLoadBalancerName() == null ^ this.elasticLoadBalancerName() == null) {
            return false;
        }
        if (other.elasticLoadBalancerName() != null && !other.elasticLoadBalancerName().equals(this.elasticLoadBalancerName())) {
            return false;
        }
        if (other.layerId() == null ^ this.layerId() == null) {
            return false;
        }
        if (other.layerId() != null && !other.layerId().equals(this.layerId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (elasticLoadBalancerName() != null) {
            sb.append("ElasticLoadBalancerName: ").append(elasticLoadBalancerName()).append(",");
        }
        if (layerId() != null) {
            sb.append("LayerId: ").append(layerId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DetachElasticLoadBalancerRequest> {
        /**
         * <p>
         * The Elastic Load Balancing instance's name.
         * </p>
         * 
         * @param elasticLoadBalancerName
         *        The Elastic Load Balancing instance's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticLoadBalancerName(String elasticLoadBalancerName);

        /**
         * <p>
         * The ID of the layer that the Elastic Load Balancing instance is attached to.
         * </p>
         * 
         * @param layerId
         *        The ID of the layer that the Elastic Load Balancing instance is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerId(String layerId);
    }

    private static final class BuilderImpl implements Builder {
        private String elasticLoadBalancerName;

        private String layerId;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachElasticLoadBalancerRequest model) {
            setElasticLoadBalancerName(model.elasticLoadBalancerName);
            setLayerId(model.layerId);
        }

        public final String getElasticLoadBalancerName() {
            return elasticLoadBalancerName;
        }

        @Override
        public final Builder elasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
            return this;
        }

        public final void setElasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
        }

        public final String getLayerId() {
            return layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        @Override
        public DetachElasticLoadBalancerRequest build() {
            return new DetachElasticLoadBalancerRequest(this);
        }
    }
}
