/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeStackProvisioningParameters</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStackProvisioningParametersResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeStackProvisioningParametersResponse.Builder, DescribeStackProvisioningParametersResponse> {
    private final String agentInstallerUrl;

    private final Map<String, String> parameters;

    private DescribeStackProvisioningParametersResponse(BuilderImpl builder) {
        this.agentInstallerUrl = builder.agentInstallerUrl;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The AWS OpsWorks Stacks agent installer's URL.
     * </p>
     * 
     * @return The AWS OpsWorks Stacks agent installer's URL.
     */
    public String agentInstallerUrl() {
        return agentInstallerUrl;
    }

    /**
     * <p>
     * An embedded object that contains the provisioning parameters.
     * </p>
     * 
     * @return An embedded object that contains the provisioning parameters.
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((agentInstallerUrl() == null) ? 0 : agentInstallerUrl().hashCode());
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackProvisioningParametersResponse)) {
            return false;
        }
        DescribeStackProvisioningParametersResponse other = (DescribeStackProvisioningParametersResponse) obj;
        if (other.agentInstallerUrl() == null ^ this.agentInstallerUrl() == null) {
            return false;
        }
        if (other.agentInstallerUrl() != null && !other.agentInstallerUrl().equals(this.agentInstallerUrl())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (agentInstallerUrl() != null) {
            sb.append("AgentInstallerUrl: ").append(agentInstallerUrl()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeStackProvisioningParametersResponse> {
        /**
         * <p>
         * The AWS OpsWorks Stacks agent installer's URL.
         * </p>
         * 
         * @param agentInstallerUrl
         *        The AWS OpsWorks Stacks agent installer's URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentInstallerUrl(String agentInstallerUrl);

        /**
         * <p>
         * An embedded object that contains the provisioning parameters.
         * </p>
         * 
         * @param parameters
         *        An embedded object that contains the provisioning parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);
    }

    private static final class BuilderImpl implements Builder {
        private String agentInstallerUrl;

        private Map<String, String> parameters = new SdkInternalMap<>();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackProvisioningParametersResponse model) {
            setAgentInstallerUrl(model.agentInstallerUrl);
            setParameters(model.parameters);
        }

        public final String getAgentInstallerUrl() {
            return agentInstallerUrl;
        }

        @Override
        public final Builder agentInstallerUrl(String agentInstallerUrl) {
            this.agentInstallerUrl = agentInstallerUrl;
            return this;
        }

        public final void setAgentInstallerUrl(String agentInstallerUrl) {
            this.agentInstallerUrl = agentInstallerUrl;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        @Override
        public DescribeStackProvisioningParametersResponse build() {
            return new DescribeStackProvisioningParametersResponse(this);
        }
    }
}
