/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeLoadBasedAutoScaling</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLoadBasedAutoScalingResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeLoadBasedAutoScalingResponse.Builder, DescribeLoadBasedAutoScalingResponse> {
    private final List<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations;

    private DescribeLoadBasedAutoScalingResponse(BuilderImpl builder) {
        this.loadBasedAutoScalingConfigurations = builder.loadBasedAutoScalingConfigurations;
    }

    /**
     * <p>
     * An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's configuration.
     * </p>
     * 
     * @return An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's
     *         configuration.
     */
    public List<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations() {
        return loadBasedAutoScalingConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + ((loadBasedAutoScalingConfigurations() == null) ? 0 : loadBasedAutoScalingConfigurations().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBasedAutoScalingResponse)) {
            return false;
        }
        DescribeLoadBasedAutoScalingResponse other = (DescribeLoadBasedAutoScalingResponse) obj;
        if (other.loadBasedAutoScalingConfigurations() == null ^ this.loadBasedAutoScalingConfigurations() == null) {
            return false;
        }
        if (other.loadBasedAutoScalingConfigurations() != null
                && !other.loadBasedAutoScalingConfigurations().equals(this.loadBasedAutoScalingConfigurations())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (loadBasedAutoScalingConfigurations() != null) {
            sb.append("LoadBasedAutoScalingConfigurations: ").append(loadBasedAutoScalingConfigurations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeLoadBasedAutoScalingResponse> {
        /**
         * <p>
         * An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's configuration.
         * </p>
         * 
         * @param loadBasedAutoScalingConfigurations
         *        An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBasedAutoScalingConfigurations(
                Collection<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations);

        /**
         * <p>
         * An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's configuration.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setLoadBasedAutoScalingConfigurations(java.util.Collection)} or
         * {@link #withLoadBasedAutoScalingConfigurations(java.util.Collection)} if you want to override the existing
         * values.
         * </p>
         * 
         * @param loadBasedAutoScalingConfigurations
         *        An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBasedAutoScalingConfigurations(LoadBasedAutoScalingConfiguration... loadBasedAutoScalingConfigurations);
    }

    private static final class BuilderImpl implements Builder {
        private List<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBasedAutoScalingResponse model) {
            setLoadBasedAutoScalingConfigurations(model.loadBasedAutoScalingConfigurations);
        }

        public final Collection<LoadBasedAutoScalingConfiguration> getLoadBasedAutoScalingConfigurations() {
            return loadBasedAutoScalingConfigurations;
        }

        @Override
        public final Builder loadBasedAutoScalingConfigurations(
                Collection<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations) {
            this.loadBasedAutoScalingConfigurations = LoadBasedAutoScalingConfigurationsCopier
                    .copy(loadBasedAutoScalingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBasedAutoScalingConfigurations(
                LoadBasedAutoScalingConfiguration... loadBasedAutoScalingConfigurations) {
            if (this.loadBasedAutoScalingConfigurations == null) {
                this.loadBasedAutoScalingConfigurations = new SdkInternalList<>(loadBasedAutoScalingConfigurations.length);
            }
            for (LoadBasedAutoScalingConfiguration e : loadBasedAutoScalingConfigurations) {
                this.loadBasedAutoScalingConfigurations.add(e);
            }
            return this;
        }

        public final void setLoadBasedAutoScalingConfigurations(
                Collection<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations) {
            this.loadBasedAutoScalingConfigurations = LoadBasedAutoScalingConfigurationsCopier
                    .copy(loadBasedAutoScalingConfigurations);
        }

        @SafeVarargs
        public final void setLoadBasedAutoScalingConfigurations(
                LoadBasedAutoScalingConfiguration... loadBasedAutoScalingConfigurations) {
            if (this.loadBasedAutoScalingConfigurations == null) {
                this.loadBasedAutoScalingConfigurations = new SdkInternalList<>(loadBasedAutoScalingConfigurations.length);
            }
            for (LoadBasedAutoScalingConfiguration e : loadBasedAutoScalingConfigurations) {
                this.loadBasedAutoScalingConfigurations.add(e);
            }
        }

        @Override
        public DescribeLoadBasedAutoScalingResponse build() {
            return new DescribeLoadBasedAutoScalingResponse(this);
        }
    }
}
