/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeEcsClusters</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeEcsClustersResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeEcsClustersResponse.Builder, DescribeEcsClustersResponse> {
    private final List<EcsCluster> ecsClusters;

    private final String nextToken;

    private DescribeEcsClustersResponse(BuilderImpl builder) {
        this.ecsClusters = builder.ecsClusters;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <code>EcsCluster</code> objects containing the cluster descriptions.
     * </p>
     * 
     * @return A list of <code>EcsCluster</code> objects containing the cluster descriptions.
     */
    public List<EcsCluster> ecsClusters() {
        return ecsClusters;
    }

    /**
     * <p>
     * If a paginated request does not return all of the remaining results, this parameter is set to a token that you
     * can assign to the request object's <code>NextToken</code> parameter to retrieve the next set of results. If the
     * previous paginated request returned all of the remaining results, this parameter is set to <code>null</code>.
     * </p>
     * 
     * @return If a paginated request does not return all of the remaining results, this parameter is set to a token
     *         that you can assign to the request object's <code>NextToken</code> parameter to retrieve the next set of
     *         results. If the previous paginated request returned all of the remaining results, this parameter is set
     *         to <code>null</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ecsClusters() == null) ? 0 : ecsClusters().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEcsClustersResponse)) {
            return false;
        }
        DescribeEcsClustersResponse other = (DescribeEcsClustersResponse) obj;
        if (other.ecsClusters() == null ^ this.ecsClusters() == null) {
            return false;
        }
        if (other.ecsClusters() != null && !other.ecsClusters().equals(this.ecsClusters())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (ecsClusters() != null) {
            sb.append("EcsClusters: ").append(ecsClusters()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeEcsClustersResponse> {
        /**
         * <p>
         * A list of <code>EcsCluster</code> objects containing the cluster descriptions.
         * </p>
         * 
         * @param ecsClusters
         *        A list of <code>EcsCluster</code> objects containing the cluster descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusters(Collection<EcsCluster> ecsClusters);

        /**
         * <p>
         * A list of <code>EcsCluster</code> objects containing the cluster descriptions.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEcsClusters(java.util.Collection)} or {@link #withEcsClusters(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param ecsClusters
         *        A list of <code>EcsCluster</code> objects containing the cluster descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusters(EcsCluster... ecsClusters);

        /**
         * <p>
         * If a paginated request does not return all of the remaining results, this parameter is set to a token that
         * you can assign to the request object's <code>NextToken</code> parameter to retrieve the next set of results.
         * If the previous paginated request returned all of the remaining results, this parameter is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If a paginated request does not return all of the remaining results, this parameter is set to a token
         *        that you can assign to the request object's <code>NextToken</code> parameter to retrieve the next set
         *        of results. If the previous paginated request returned all of the remaining results, this parameter is
         *        set to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<EcsCluster> ecsClusters = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEcsClustersResponse model) {
            setEcsClusters(model.ecsClusters);
            setNextToken(model.nextToken);
        }

        public final Collection<EcsCluster> getEcsClusters() {
            return ecsClusters;
        }

        @Override
        public final Builder ecsClusters(Collection<EcsCluster> ecsClusters) {
            this.ecsClusters = EcsClustersCopier.copy(ecsClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsClusters(EcsCluster... ecsClusters) {
            if (this.ecsClusters == null) {
                this.ecsClusters = new SdkInternalList<>(ecsClusters.length);
            }
            for (EcsCluster e : ecsClusters) {
                this.ecsClusters.add(e);
            }
            return this;
        }

        public final void setEcsClusters(Collection<EcsCluster> ecsClusters) {
            this.ecsClusters = EcsClustersCopier.copy(ecsClusters);
        }

        @SafeVarargs
        public final void setEcsClusters(EcsCluster... ecsClusters) {
            if (this.ecsClusters == null) {
                this.ecsClusters = new SdkInternalList<>(ecsClusters.length);
            }
            for (EcsCluster e : ecsClusters) {
                this.ecsClusters.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEcsClustersResponse build() {
            return new DescribeEcsClustersResponse(this);
        }
    }
}
