/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.runtime.StandardMemberCopier;

@Generated("software.amazon.awssdk:codegen")
final class DeploymentCommandArgsCopier {
    static Map<String, List<String>> copy(Map<String, ? extends Collection<String>> deploymentCommandArgsParam) {
        if (deploymentCommandArgsParam == null) {
            return null;
        }
        Map<String, List<String>> deploymentCommandArgsParamCopy = new SdkInternalMap<>(deploymentCommandArgsParam.size());
        for (Map.Entry<String, ? extends Collection<String>> e : deploymentCommandArgsParam.entrySet()) {
            deploymentCommandArgsParamCopy.put(StandardMemberCopier.copy(e.getKey()), StringsCopier.copy(e.getValue()));
        }
        return deploymentCommandArgsParamCopy;
    }
}
