/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentStatus {
    PENDING_UPDATE("PENDING_UPDATE"),
    IN_PROGRESS("IN_PROGRESS"),
    COMPLETED("COMPLETED"),
    NOT_ELIGIBLE("NOT_ELIGIBLE"),
    ELIGIBLE("ELIGIBLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentStatus> VALUE_MAP;
    private final String value;

    private DeploymentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentStatus> knownValues() {
        EnumSet<DeploymentStatus> knownValues = EnumSet.allOf(DeploymentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentStatus.class, DeploymentStatus::toString);
    }
}

