/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.DomainPackageStatus;
import software.amazon.awssdk.services.opensearch.model.ErrorDetails;
import software.amazon.awssdk.services.opensearch.model.PackageAssociationConfiguration;
import software.amazon.awssdk.services.opensearch.model.PackageIDListCopier;
import software.amazon.awssdk.services.opensearch.model.PackageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainPackageDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainPackageDetails> {
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageID").getter(DomainPackageDetails.getter(DomainPackageDetails::packageID)).setter(DomainPackageDetails.setter(Builder::packageID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageID").build()}).build();
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageName").getter(DomainPackageDetails.getter(DomainPackageDetails::packageName)).setter(DomainPackageDetails.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()}).build();
    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageType").getter(DomainPackageDetails.getter(DomainPackageDetails::packageTypeAsString)).setter(DomainPackageDetails.setter(Builder::packageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageType").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(DomainPackageDetails.getter(DomainPackageDetails::lastUpdated)).setter(DomainPackageDetails.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DomainPackageDetails.getter(DomainPackageDetails::domainName)).setter(DomainPackageDetails.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> DOMAIN_PACKAGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainPackageStatus").getter(DomainPackageDetails.getter(DomainPackageDetails::domainPackageStatusAsString)).setter(DomainPackageDetails.setter(Builder::domainPackageStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainPackageStatus").build()}).build();
    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageVersion").getter(DomainPackageDetails.getter(DomainPackageDetails::packageVersion)).setter(DomainPackageDetails.setter(Builder::packageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()}).build();
    private static final SdkField<List<String>> PREREQUISITE_PACKAGE_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrerequisitePackageIDList").getter(DomainPackageDetails.getter(DomainPackageDetails::prerequisitePackageIDList)).setter(DomainPackageDetails.setter(Builder::prerequisitePackageIDList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrerequisitePackageIDList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REFERENCE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReferencePath").getter(DomainPackageDetails.getter(DomainPackageDetails::referencePath)).setter(DomainPackageDetails.setter(Builder::referencePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferencePath").build()}).build();
    private static final SdkField<ErrorDetails> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorDetails").getter(DomainPackageDetails.getter(DomainPackageDetails::errorDetails)).setter(DomainPackageDetails.setter(Builder::errorDetails)).constructor(ErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build()}).build();
    private static final SdkField<PackageAssociationConfiguration> ASSOCIATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssociationConfiguration").getter(DomainPackageDetails.getter(DomainPackageDetails::associationConfiguration)).setter(DomainPackageDetails.setter(Builder::associationConfiguration)).constructor(PackageAssociationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_ID_FIELD, PACKAGE_NAME_FIELD, PACKAGE_TYPE_FIELD, LAST_UPDATED_FIELD, DOMAIN_NAME_FIELD, DOMAIN_PACKAGE_STATUS_FIELD, PACKAGE_VERSION_FIELD, PREREQUISITE_PACKAGE_ID_LIST_FIELD, REFERENCE_PATH_FIELD, ERROR_DETAILS_FIELD, ASSOCIATION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DomainPackageDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String packageID;
    private final String packageName;
    private final String packageType;
    private final Instant lastUpdated;
    private final String domainName;
    private final String domainPackageStatus;
    private final String packageVersion;
    private final List<String> prerequisitePackageIDList;
    private final String referencePath;
    private final ErrorDetails errorDetails;
    private final PackageAssociationConfiguration associationConfiguration;

    private DomainPackageDetails(BuilderImpl builder) {
        this.packageID = builder.packageID;
        this.packageName = builder.packageName;
        this.packageType = builder.packageType;
        this.lastUpdated = builder.lastUpdated;
        this.domainName = builder.domainName;
        this.domainPackageStatus = builder.domainPackageStatus;
        this.packageVersion = builder.packageVersion;
        this.prerequisitePackageIDList = builder.prerequisitePackageIDList;
        this.referencePath = builder.referencePath;
        this.errorDetails = builder.errorDetails;
        this.associationConfiguration = builder.associationConfiguration;
    }

    public final String packageID() {
        return this.packageID;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final PackageType packageType() {
        return PackageType.fromValue(this.packageType);
    }

    public final String packageTypeAsString() {
        return this.packageType;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final DomainPackageStatus domainPackageStatus() {
        return DomainPackageStatus.fromValue(this.domainPackageStatus);
    }

    public final String domainPackageStatusAsString() {
        return this.domainPackageStatus;
    }

    public final String packageVersion() {
        return this.packageVersion;
    }

    public final boolean hasPrerequisitePackageIDList() {
        return this.prerequisitePackageIDList != null && !(this.prerequisitePackageIDList instanceof SdkAutoConstructList);
    }

    public final List<String> prerequisitePackageIDList() {
        return this.prerequisitePackageIDList;
    }

    public final String referencePath() {
        return this.referencePath;
    }

    public final ErrorDetails errorDetails() {
        return this.errorDetails;
    }

    public final PackageAssociationConfiguration associationConfiguration() {
        return this.associationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.packageID());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainPackageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrerequisitePackageIDList() ? this.prerequisitePackageIDList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.referencePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainPackageDetails)) {
            return false;
        }
        DomainPackageDetails other = (DomainPackageDetails)obj;
        return Objects.equals(this.packageID(), other.packageID()) && Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.packageTypeAsString(), other.packageTypeAsString()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.domainPackageStatusAsString(), other.domainPackageStatusAsString()) && Objects.equals(this.packageVersion(), other.packageVersion()) && this.hasPrerequisitePackageIDList() == other.hasPrerequisitePackageIDList() && Objects.equals(this.prerequisitePackageIDList(), other.prerequisitePackageIDList()) && Objects.equals(this.referencePath(), other.referencePath()) && Objects.equals(this.errorDetails(), other.errorDetails()) && Objects.equals(this.associationConfiguration(), other.associationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DomainPackageDetails").add("PackageID", (Object)this.packageID()).add("PackageName", (Object)this.packageName()).add("PackageType", (Object)this.packageTypeAsString()).add("LastUpdated", (Object)this.lastUpdated()).add("DomainName", (Object)this.domainName()).add("DomainPackageStatus", (Object)this.domainPackageStatusAsString()).add("PackageVersion", (Object)this.packageVersion()).add("PrerequisitePackageIDList", this.hasPrerequisitePackageIDList() ? this.prerequisitePackageIDList() : null).add("ReferencePath", (Object)this.referencePath()).add("ErrorDetails", (Object)this.errorDetails()).add("AssociationConfiguration", (Object)this.associationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PackageID": {
                return Optional.ofNullable(clazz.cast(this.packageID()));
            }
            case "PackageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "PackageType": {
                return Optional.ofNullable(clazz.cast(this.packageTypeAsString()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "DomainPackageStatus": {
                return Optional.ofNullable(clazz.cast(this.domainPackageStatusAsString()));
            }
            case "PackageVersion": {
                return Optional.ofNullable(clazz.cast(this.packageVersion()));
            }
            case "PrerequisitePackageIDList": {
                return Optional.ofNullable(clazz.cast(this.prerequisitePackageIDList()));
            }
            case "ReferencePath": {
                return Optional.ofNullable(clazz.cast(this.referencePath()));
            }
            case "ErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
            case "AssociationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.associationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PackageID", PACKAGE_ID_FIELD);
        map.put("PackageName", PACKAGE_NAME_FIELD);
        map.put("PackageType", PACKAGE_TYPE_FIELD);
        map.put("LastUpdated", LAST_UPDATED_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("DomainPackageStatus", DOMAIN_PACKAGE_STATUS_FIELD);
        map.put("PackageVersion", PACKAGE_VERSION_FIELD);
        map.put("PrerequisitePackageIDList", PREREQUISITE_PACKAGE_ID_LIST_FIELD);
        map.put("ReferencePath", REFERENCE_PATH_FIELD);
        map.put("ErrorDetails", ERROR_DETAILS_FIELD);
        map.put("AssociationConfiguration", ASSOCIATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainPackageDetails, T> g) {
        return obj -> g.apply((DomainPackageDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String packageID;
        private String packageName;
        private String packageType;
        private Instant lastUpdated;
        private String domainName;
        private String domainPackageStatus;
        private String packageVersion;
        private List<String> prerequisitePackageIDList = DefaultSdkAutoConstructList.getInstance();
        private String referencePath;
        private ErrorDetails errorDetails;
        private PackageAssociationConfiguration associationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainPackageDetails model) {
            this.packageID(model.packageID);
            this.packageName(model.packageName);
            this.packageType(model.packageType);
            this.lastUpdated(model.lastUpdated);
            this.domainName(model.domainName);
            this.domainPackageStatus(model.domainPackageStatus);
            this.packageVersion(model.packageVersion);
            this.prerequisitePackageIDList(model.prerequisitePackageIDList);
            this.referencePath(model.referencePath);
            this.errorDetails(model.errorDetails);
            this.associationConfiguration(model.associationConfiguration);
        }

        public final String getPackageID() {
            return this.packageID;
        }

        public final void setPackageID(String packageID) {
            this.packageID = packageID;
        }

        @Override
        public final Builder packageID(String packageID) {
            this.packageID = packageID;
            return this;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageType() {
            return this.packageType;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDomainPackageStatus() {
            return this.domainPackageStatus;
        }

        public final void setDomainPackageStatus(String domainPackageStatus) {
            this.domainPackageStatus = domainPackageStatus;
        }

        @Override
        public final Builder domainPackageStatus(String domainPackageStatus) {
            this.domainPackageStatus = domainPackageStatus;
            return this;
        }

        @Override
        public final Builder domainPackageStatus(DomainPackageStatus domainPackageStatus) {
            this.domainPackageStatus(domainPackageStatus == null ? null : domainPackageStatus.toString());
            return this;
        }

        public final String getPackageVersion() {
            return this.packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final Collection<String> getPrerequisitePackageIDList() {
            if (this.prerequisitePackageIDList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.prerequisitePackageIDList;
        }

        public final void setPrerequisitePackageIDList(Collection<String> prerequisitePackageIDList) {
            this.prerequisitePackageIDList = PackageIDListCopier.copy(prerequisitePackageIDList);
        }

        @Override
        public final Builder prerequisitePackageIDList(Collection<String> prerequisitePackageIDList) {
            this.prerequisitePackageIDList = PackageIDListCopier.copy(prerequisitePackageIDList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prerequisitePackageIDList(String ... prerequisitePackageIDList) {
            this.prerequisitePackageIDList(Arrays.asList(prerequisitePackageIDList));
            return this;
        }

        public final String getReferencePath() {
            return this.referencePath;
        }

        public final void setReferencePath(String referencePath) {
            this.referencePath = referencePath;
        }

        @Override
        public final Builder referencePath(String referencePath) {
            this.referencePath = referencePath;
            return this;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return this.errorDetails != null ? this.errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final PackageAssociationConfiguration.Builder getAssociationConfiguration() {
            return this.associationConfiguration != null ? this.associationConfiguration.toBuilder() : null;
        }

        public final void setAssociationConfiguration(PackageAssociationConfiguration.BuilderImpl associationConfiguration) {
            this.associationConfiguration = associationConfiguration != null ? associationConfiguration.build() : null;
        }

        @Override
        public final Builder associationConfiguration(PackageAssociationConfiguration associationConfiguration) {
            this.associationConfiguration = associationConfiguration;
            return this;
        }

        public DomainPackageDetails build() {
            return new DomainPackageDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainPackageDetails> {
        public Builder packageID(String var1);

        public Builder packageName(String var1);

        public Builder packageType(String var1);

        public Builder packageType(PackageType var1);

        public Builder lastUpdated(Instant var1);

        public Builder domainName(String var1);

        public Builder domainPackageStatus(String var1);

        public Builder domainPackageStatus(DomainPackageStatus var1);

        public Builder packageVersion(String var1);

        public Builder prerequisitePackageIDList(Collection<String> var1);

        public Builder prerequisitePackageIDList(String ... var1);

        public Builder referencePath(String var1);

        public Builder errorDetails(ErrorDetails var1);

        default public Builder errorDetails(Consumer<ErrorDetails.Builder> errorDetails) {
            return this.errorDetails((ErrorDetails)((ErrorDetails.Builder)ErrorDetails.builder().applyMutation(errorDetails)).build());
        }

        public Builder associationConfiguration(PackageAssociationConfiguration var1);

        default public Builder associationConfiguration(Consumer<PackageAssociationConfiguration.Builder> associationConfiguration) {
            return this.associationConfiguration((PackageAssociationConfiguration)((PackageAssociationConfiguration.Builder)PackageAssociationConfiguration.builder().applyMutation(associationConfiguration)).build());
        }
    }
}

