/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.IAMFederationOptionsInput;
import software.amazon.awssdk.services.opensearch.model.JWTOptionsInput;
import software.amazon.awssdk.services.opensearch.model.MasterUserOptions;
import software.amazon.awssdk.services.opensearch.model.SAMLOptionsInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdvancedSecurityOptionsInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdvancedSecurityOptionsInput> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(AdvancedSecurityOptionsInput.getter(AdvancedSecurityOptionsInput::enabled)).setter(AdvancedSecurityOptionsInput.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<Boolean> INTERNAL_USER_DATABASE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("InternalUserDatabaseEnabled").getter(AdvancedSecurityOptionsInput.getter(AdvancedSecurityOptionsInput::internalUserDatabaseEnabled)).setter(AdvancedSecurityOptionsInput.setter(Builder::internalUserDatabaseEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternalUserDatabaseEnabled").build()}).build();
    private static final SdkField<MasterUserOptions> MASTER_USER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MasterUserOptions").getter(AdvancedSecurityOptionsInput.getter(AdvancedSecurityOptionsInput::masterUserOptions)).setter(AdvancedSecurityOptionsInput.setter(Builder::masterUserOptions)).constructor(MasterUserOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserOptions").build()}).build();
    private static final SdkField<SAMLOptionsInput> SAML_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SAMLOptions").getter(AdvancedSecurityOptionsInput.getter(AdvancedSecurityOptionsInput::samlOptions)).setter(AdvancedSecurityOptionsInput.setter(Builder::samlOptions)).constructor(SAMLOptionsInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLOptions").build()}).build();
    private static final SdkField<JWTOptionsInput> JWT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JWTOptions").getter(AdvancedSecurityOptionsInput.getter(AdvancedSecurityOptionsInput::jwtOptions)).setter(AdvancedSecurityOptionsInput.setter(Builder::jwtOptions)).constructor(JWTOptionsInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JWTOptions").build()}).build();
    private static final SdkField<IAMFederationOptionsInput> IAM_FEDERATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IAMFederationOptions").getter(AdvancedSecurityOptionsInput.getter(AdvancedSecurityOptionsInput::iamFederationOptions)).setter(AdvancedSecurityOptionsInput.setter(Builder::iamFederationOptions)).constructor(IAMFederationOptionsInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMFederationOptions").build()}).build();
    private static final SdkField<Boolean> ANONYMOUS_AUTH_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AnonymousAuthEnabled").getter(AdvancedSecurityOptionsInput.getter(AdvancedSecurityOptionsInput::anonymousAuthEnabled)).setter(AdvancedSecurityOptionsInput.setter(Builder::anonymousAuthEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnonymousAuthEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, INTERNAL_USER_DATABASE_ENABLED_FIELD, MASTER_USER_OPTIONS_FIELD, SAML_OPTIONS_FIELD, JWT_OPTIONS_FIELD, IAM_FEDERATION_OPTIONS_FIELD, ANONYMOUS_AUTH_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AdvancedSecurityOptionsInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final Boolean internalUserDatabaseEnabled;
    private final MasterUserOptions masterUserOptions;
    private final SAMLOptionsInput samlOptions;
    private final JWTOptionsInput jwtOptions;
    private final IAMFederationOptionsInput iamFederationOptions;
    private final Boolean anonymousAuthEnabled;

    private AdvancedSecurityOptionsInput(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.internalUserDatabaseEnabled = builder.internalUserDatabaseEnabled;
        this.masterUserOptions = builder.masterUserOptions;
        this.samlOptions = builder.samlOptions;
        this.jwtOptions = builder.jwtOptions;
        this.iamFederationOptions = builder.iamFederationOptions;
        this.anonymousAuthEnabled = builder.anonymousAuthEnabled;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Boolean internalUserDatabaseEnabled() {
        return this.internalUserDatabaseEnabled;
    }

    public final MasterUserOptions masterUserOptions() {
        return this.masterUserOptions;
    }

    public final SAMLOptionsInput samlOptions() {
        return this.samlOptions;
    }

    public final JWTOptionsInput jwtOptions() {
        return this.jwtOptions;
    }

    public final IAMFederationOptionsInput iamFederationOptions() {
        return this.iamFederationOptions;
    }

    public final Boolean anonymousAuthEnabled() {
        return this.anonymousAuthEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.internalUserDatabaseEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.samlOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.jwtOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamFederationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.anonymousAuthEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedSecurityOptionsInput)) {
            return false;
        }
        AdvancedSecurityOptionsInput other = (AdvancedSecurityOptionsInput)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.internalUserDatabaseEnabled(), other.internalUserDatabaseEnabled()) && Objects.equals(this.masterUserOptions(), other.masterUserOptions()) && Objects.equals(this.samlOptions(), other.samlOptions()) && Objects.equals(this.jwtOptions(), other.jwtOptions()) && Objects.equals(this.iamFederationOptions(), other.iamFederationOptions()) && Objects.equals(this.anonymousAuthEnabled(), other.anonymousAuthEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"AdvancedSecurityOptionsInput").add("Enabled", (Object)this.enabled()).add("InternalUserDatabaseEnabled", (Object)this.internalUserDatabaseEnabled()).add("MasterUserOptions", (Object)this.masterUserOptions()).add("SAMLOptions", (Object)this.samlOptions()).add("JWTOptions", (Object)this.jwtOptions()).add("IAMFederationOptions", (Object)this.iamFederationOptions()).add("AnonymousAuthEnabled", (Object)this.anonymousAuthEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "InternalUserDatabaseEnabled": {
                return Optional.ofNullable(clazz.cast(this.internalUserDatabaseEnabled()));
            }
            case "MasterUserOptions": {
                return Optional.ofNullable(clazz.cast(this.masterUserOptions()));
            }
            case "SAMLOptions": {
                return Optional.ofNullable(clazz.cast(this.samlOptions()));
            }
            case "JWTOptions": {
                return Optional.ofNullable(clazz.cast(this.jwtOptions()));
            }
            case "IAMFederationOptions": {
                return Optional.ofNullable(clazz.cast(this.iamFederationOptions()));
            }
            case "AnonymousAuthEnabled": {
                return Optional.ofNullable(clazz.cast(this.anonymousAuthEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("InternalUserDatabaseEnabled", INTERNAL_USER_DATABASE_ENABLED_FIELD);
        map.put("MasterUserOptions", MASTER_USER_OPTIONS_FIELD);
        map.put("SAMLOptions", SAML_OPTIONS_FIELD);
        map.put("JWTOptions", JWT_OPTIONS_FIELD);
        map.put("IAMFederationOptions", IAM_FEDERATION_OPTIONS_FIELD);
        map.put("AnonymousAuthEnabled", ANONYMOUS_AUTH_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdvancedSecurityOptionsInput, T> g) {
        return obj -> g.apply((AdvancedSecurityOptionsInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Boolean internalUserDatabaseEnabled;
        private MasterUserOptions masterUserOptions;
        private SAMLOptionsInput samlOptions;
        private JWTOptionsInput jwtOptions;
        private IAMFederationOptionsInput iamFederationOptions;
        private Boolean anonymousAuthEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(AdvancedSecurityOptionsInput model) {
            this.enabled(model.enabled);
            this.internalUserDatabaseEnabled(model.internalUserDatabaseEnabled);
            this.masterUserOptions(model.masterUserOptions);
            this.samlOptions(model.samlOptions);
            this.jwtOptions(model.jwtOptions);
            this.iamFederationOptions(model.iamFederationOptions);
            this.anonymousAuthEnabled(model.anonymousAuthEnabled);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Boolean getInternalUserDatabaseEnabled() {
            return this.internalUserDatabaseEnabled;
        }

        public final void setInternalUserDatabaseEnabled(Boolean internalUserDatabaseEnabled) {
            this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
        }

        @Override
        public final Builder internalUserDatabaseEnabled(Boolean internalUserDatabaseEnabled) {
            this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
            return this;
        }

        public final MasterUserOptions.Builder getMasterUserOptions() {
            return this.masterUserOptions != null ? this.masterUserOptions.toBuilder() : null;
        }

        public final void setMasterUserOptions(MasterUserOptions.BuilderImpl masterUserOptions) {
            this.masterUserOptions = masterUserOptions != null ? masterUserOptions.build() : null;
        }

        @Override
        public final Builder masterUserOptions(MasterUserOptions masterUserOptions) {
            this.masterUserOptions = masterUserOptions;
            return this;
        }

        public final SAMLOptionsInput.Builder getSamlOptions() {
            return this.samlOptions != null ? this.samlOptions.toBuilder() : null;
        }

        public final void setSamlOptions(SAMLOptionsInput.BuilderImpl samlOptions) {
            this.samlOptions = samlOptions != null ? samlOptions.build() : null;
        }

        @Override
        public final Builder samlOptions(SAMLOptionsInput samlOptions) {
            this.samlOptions = samlOptions;
            return this;
        }

        public final JWTOptionsInput.Builder getJwtOptions() {
            return this.jwtOptions != null ? this.jwtOptions.toBuilder() : null;
        }

        public final void setJwtOptions(JWTOptionsInput.BuilderImpl jwtOptions) {
            this.jwtOptions = jwtOptions != null ? jwtOptions.build() : null;
        }

        @Override
        public final Builder jwtOptions(JWTOptionsInput jwtOptions) {
            this.jwtOptions = jwtOptions;
            return this;
        }

        public final IAMFederationOptionsInput.Builder getIamFederationOptions() {
            return this.iamFederationOptions != null ? this.iamFederationOptions.toBuilder() : null;
        }

        public final void setIamFederationOptions(IAMFederationOptionsInput.BuilderImpl iamFederationOptions) {
            this.iamFederationOptions = iamFederationOptions != null ? iamFederationOptions.build() : null;
        }

        @Override
        public final Builder iamFederationOptions(IAMFederationOptionsInput iamFederationOptions) {
            this.iamFederationOptions = iamFederationOptions;
            return this;
        }

        public final Boolean getAnonymousAuthEnabled() {
            return this.anonymousAuthEnabled;
        }

        public final void setAnonymousAuthEnabled(Boolean anonymousAuthEnabled) {
            this.anonymousAuthEnabled = anonymousAuthEnabled;
        }

        @Override
        public final Builder anonymousAuthEnabled(Boolean anonymousAuthEnabled) {
            this.anonymousAuthEnabled = anonymousAuthEnabled;
            return this;
        }

        public AdvancedSecurityOptionsInput build() {
            return new AdvancedSecurityOptionsInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdvancedSecurityOptionsInput> {
        public Builder enabled(Boolean var1);

        public Builder internalUserDatabaseEnabled(Boolean var1);

        public Builder masterUserOptions(MasterUserOptions var1);

        default public Builder masterUserOptions(Consumer<MasterUserOptions.Builder> masterUserOptions) {
            return this.masterUserOptions((MasterUserOptions)((MasterUserOptions.Builder)MasterUserOptions.builder().applyMutation(masterUserOptions)).build());
        }

        public Builder samlOptions(SAMLOptionsInput var1);

        default public Builder samlOptions(Consumer<SAMLOptionsInput.Builder> samlOptions) {
            return this.samlOptions((SAMLOptionsInput)((SAMLOptionsInput.Builder)SAMLOptionsInput.builder().applyMutation(samlOptions)).build());
        }

        public Builder jwtOptions(JWTOptionsInput var1);

        default public Builder jwtOptions(Consumer<JWTOptionsInput.Builder> jwtOptions) {
            return this.jwtOptions((JWTOptionsInput)((JWTOptionsInput.Builder)JWTOptionsInput.builder().applyMutation(jwtOptions)).build());
        }

        public Builder iamFederationOptions(IAMFederationOptionsInput var1);

        default public Builder iamFederationOptions(Consumer<IAMFederationOptionsInput.Builder> iamFederationOptions) {
            return this.iamFederationOptions((IAMFederationOptionsInput)((IAMFederationOptionsInput.Builder)IAMFederationOptionsInput.builder().applyMutation(iamFederationOptions)).build());
        }

        public Builder anonymousAuthEnabled(Boolean var1);
    }
}

