/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An exception for attempting to schedule a domain action during an unavailable time slot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotNotAvailableException extends OpenSearchException implements
        ToCopyableBuilder<SlotNotAvailableException.Builder, SlotNotAvailableException> {
    private static final SdkField<List<Long>> SLOT_SUGGESTIONS_FIELD = SdkField
            .<List<Long>> builder(MarshallingType.LIST)
            .memberName("SlotSuggestions")
            .getter(getter(SlotNotAvailableException::slotSuggestions))
            .setter(setter(Builder::slotSuggestions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlotSuggestions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_SUGGESTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Long> slotSuggestions;

    private SlotNotAvailableException(BuilderImpl builder) {
        super(builder);
        this.slotSuggestions = builder.slotSuggestions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * For responses, this returns true if the service returned a value for the SlotSuggestions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public boolean hasSlotSuggestions() {
        return slotSuggestions != null && !(slotSuggestions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Alternate time slots during which OpenSearch Service has available capacity to schedule a domain action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlotSuggestions} method.
     * </p>
     * 
     * @return Alternate time slots during which OpenSearch Service has available capacity to schedule a domain action.
     */
    public List<Long> slotSuggestions() {
        return slotSuggestions;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SlotSuggestions", SLOT_SUGGESTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlotNotAvailableException, T> g) {
        return obj -> g.apply((SlotNotAvailableException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotNotAvailableException>, OpenSearchException.Builder {
        /**
         * <p>
         * Alternate time slots during which OpenSearch Service has available capacity to schedule a domain action.
         * </p>
         * 
         * @param slotSuggestions
         *        Alternate time slots during which OpenSearch Service has available capacity to schedule a domain
         *        action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotSuggestions(Collection<Long> slotSuggestions);

        /**
         * <p>
         * Alternate time slots during which OpenSearch Service has available capacity to schedule a domain action.
         * </p>
         * 
         * @param slotSuggestions
         *        Alternate time slots during which OpenSearch Service has available capacity to schedule a domain
         *        action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotSuggestions(Long... slotSuggestions);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);

        @Override
        Builder numAttempts(Integer numAttempts);
    }

    static final class BuilderImpl extends OpenSearchException.BuilderImpl implements Builder {
        private List<Long> slotSuggestions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SlotNotAvailableException model) {
            super(model);
            slotSuggestions(model.slotSuggestions);
        }

        public final Collection<Long> getSlotSuggestions() {
            if (slotSuggestions instanceof SdkAutoConstructList) {
                return null;
            }
            return slotSuggestions;
        }

        public final void setSlotSuggestions(Collection<Long> slotSuggestions) {
            this.slotSuggestions = SlotListCopier.copy(slotSuggestions);
        }

        @Override
        public final Builder slotSuggestions(Collection<Long> slotSuggestions) {
            this.slotSuggestions = SlotListCopier.copy(slotSuggestions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotSuggestions(Long... slotSuggestions) {
            slotSuggestions(Arrays.asList(slotSuggestions));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public SlotNotAvailableException build() {
            return new SlotNotAvailableException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
