/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for associating a package with a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageAssociationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageAssociationConfiguration.Builder, PackageAssociationConfiguration> {
    private static final SdkField<KeyStoreAccessOption> KEY_STORE_ACCESS_OPTION_FIELD = SdkField
            .<KeyStoreAccessOption> builder(MarshallingType.SDK_POJO).memberName("KeyStoreAccessOption")
            .getter(getter(PackageAssociationConfiguration::keyStoreAccessOption)).setter(setter(Builder::keyStoreAccessOption))
            .constructor(KeyStoreAccessOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyStoreAccessOption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(KEY_STORE_ACCESS_OPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final KeyStoreAccessOption keyStoreAccessOption;

    private PackageAssociationConfiguration(BuilderImpl builder) {
        this.keyStoreAccessOption = builder.keyStoreAccessOption;
    }

    /**
     * <p>
     * The configuration parameters to enable accessing the key store required by the package.
     * </p>
     * 
     * @return The configuration parameters to enable accessing the key store required by the package.
     */
    public final KeyStoreAccessOption keyStoreAccessOption() {
        return keyStoreAccessOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyStoreAccessOption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageAssociationConfiguration)) {
            return false;
        }
        PackageAssociationConfiguration other = (PackageAssociationConfiguration) obj;
        return Objects.equals(keyStoreAccessOption(), other.keyStoreAccessOption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageAssociationConfiguration").add("KeyStoreAccessOption", keyStoreAccessOption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyStoreAccessOption":
            return Optional.ofNullable(clazz.cast(keyStoreAccessOption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyStoreAccessOption", KEY_STORE_ACCESS_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PackageAssociationConfiguration, T> g) {
        return obj -> g.apply((PackageAssociationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageAssociationConfiguration> {
        /**
         * <p>
         * The configuration parameters to enable accessing the key store required by the package.
         * </p>
         * 
         * @param keyStoreAccessOption
         *        The configuration parameters to enable accessing the key store required by the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyStoreAccessOption(KeyStoreAccessOption keyStoreAccessOption);

        /**
         * <p>
         * The configuration parameters to enable accessing the key store required by the package.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyStoreAccessOption.Builder} avoiding
         * the need to create one manually via {@link KeyStoreAccessOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyStoreAccessOption.Builder#build()} is called immediately and
         * its result is passed to {@link #keyStoreAccessOption(KeyStoreAccessOption)}.
         * 
         * @param keyStoreAccessOption
         *        a consumer that will call methods on {@link KeyStoreAccessOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyStoreAccessOption(KeyStoreAccessOption)
         */
        default Builder keyStoreAccessOption(Consumer<KeyStoreAccessOption.Builder> keyStoreAccessOption) {
            return keyStoreAccessOption(KeyStoreAccessOption.builder().applyMutation(keyStoreAccessOption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KeyStoreAccessOption keyStoreAccessOption;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageAssociationConfiguration model) {
            keyStoreAccessOption(model.keyStoreAccessOption);
        }

        public final KeyStoreAccessOption.Builder getKeyStoreAccessOption() {
            return keyStoreAccessOption != null ? keyStoreAccessOption.toBuilder() : null;
        }

        public final void setKeyStoreAccessOption(KeyStoreAccessOption.BuilderImpl keyStoreAccessOption) {
            this.keyStoreAccessOption = keyStoreAccessOption != null ? keyStoreAccessOption.build() : null;
        }

        @Override
        public final Builder keyStoreAccessOption(KeyStoreAccessOption keyStoreAccessOption) {
            this.keyStoreAccessOption = keyStoreAccessOption;
            return this;
        }

        @Override
        public PackageAssociationConfiguration build() {
            return new PackageAssociationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
