/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum OpenSearchPartitionInstanceType {
    M3_MEDIUM_SEARCH("m3.medium.search"),

    M3_LARGE_SEARCH("m3.large.search"),

    M3_XLARGE_SEARCH("m3.xlarge.search"),

    M3_2_XLARGE_SEARCH("m3.2xlarge.search"),

    M4_LARGE_SEARCH("m4.large.search"),

    M4_XLARGE_SEARCH("m4.xlarge.search"),

    M4_2_XLARGE_SEARCH("m4.2xlarge.search"),

    M4_4_XLARGE_SEARCH("m4.4xlarge.search"),

    M4_10_XLARGE_SEARCH("m4.10xlarge.search"),

    M5_LARGE_SEARCH("m5.large.search"),

    M5_XLARGE_SEARCH("m5.xlarge.search"),

    M5_2_XLARGE_SEARCH("m5.2xlarge.search"),

    M5_4_XLARGE_SEARCH("m5.4xlarge.search"),

    M5_12_XLARGE_SEARCH("m5.12xlarge.search"),

    M5_24_XLARGE_SEARCH("m5.24xlarge.search"),

    R5_LARGE_SEARCH("r5.large.search"),

    R5_XLARGE_SEARCH("r5.xlarge.search"),

    R5_2_XLARGE_SEARCH("r5.2xlarge.search"),

    R5_4_XLARGE_SEARCH("r5.4xlarge.search"),

    R5_12_XLARGE_SEARCH("r5.12xlarge.search"),

    R5_24_XLARGE_SEARCH("r5.24xlarge.search"),

    C5_LARGE_SEARCH("c5.large.search"),

    C5_XLARGE_SEARCH("c5.xlarge.search"),

    C5_2_XLARGE_SEARCH("c5.2xlarge.search"),

    C5_4_XLARGE_SEARCH("c5.4xlarge.search"),

    C5_9_XLARGE_SEARCH("c5.9xlarge.search"),

    C5_18_XLARGE_SEARCH("c5.18xlarge.search"),

    T3_NANO_SEARCH("t3.nano.search"),

    T3_MICRO_SEARCH("t3.micro.search"),

    T3_SMALL_SEARCH("t3.small.search"),

    T3_MEDIUM_SEARCH("t3.medium.search"),

    T3_LARGE_SEARCH("t3.large.search"),

    T3_XLARGE_SEARCH("t3.xlarge.search"),

    T3_2_XLARGE_SEARCH("t3.2xlarge.search"),

    OR1_MEDIUM_SEARCH("or1.medium.search"),

    OR1_LARGE_SEARCH("or1.large.search"),

    OR1_XLARGE_SEARCH("or1.xlarge.search"),

    OR1_2_XLARGE_SEARCH("or1.2xlarge.search"),

    OR1_4_XLARGE_SEARCH("or1.4xlarge.search"),

    OR1_8_XLARGE_SEARCH("or1.8xlarge.search"),

    OR1_12_XLARGE_SEARCH("or1.12xlarge.search"),

    OR1_16_XLARGE_SEARCH("or1.16xlarge.search"),

    ULTRAWARM1_MEDIUM_SEARCH("ultrawarm1.medium.search"),

    ULTRAWARM1_LARGE_SEARCH("ultrawarm1.large.search"),

    ULTRAWARM1_XLARGE_SEARCH("ultrawarm1.xlarge.search"),

    T2_MICRO_SEARCH("t2.micro.search"),

    T2_SMALL_SEARCH("t2.small.search"),

    T2_MEDIUM_SEARCH("t2.medium.search"),

    R3_LARGE_SEARCH("r3.large.search"),

    R3_XLARGE_SEARCH("r3.xlarge.search"),

    R3_2_XLARGE_SEARCH("r3.2xlarge.search"),

    R3_4_XLARGE_SEARCH("r3.4xlarge.search"),

    R3_8_XLARGE_SEARCH("r3.8xlarge.search"),

    I2_XLARGE_SEARCH("i2.xlarge.search"),

    I2_2_XLARGE_SEARCH("i2.2xlarge.search"),

    D2_XLARGE_SEARCH("d2.xlarge.search"),

    D2_2_XLARGE_SEARCH("d2.2xlarge.search"),

    D2_4_XLARGE_SEARCH("d2.4xlarge.search"),

    D2_8_XLARGE_SEARCH("d2.8xlarge.search"),

    C4_LARGE_SEARCH("c4.large.search"),

    C4_XLARGE_SEARCH("c4.xlarge.search"),

    C4_2_XLARGE_SEARCH("c4.2xlarge.search"),

    C4_4_XLARGE_SEARCH("c4.4xlarge.search"),

    C4_8_XLARGE_SEARCH("c4.8xlarge.search"),

    R4_LARGE_SEARCH("r4.large.search"),

    R4_XLARGE_SEARCH("r4.xlarge.search"),

    R4_2_XLARGE_SEARCH("r4.2xlarge.search"),

    R4_4_XLARGE_SEARCH("r4.4xlarge.search"),

    R4_8_XLARGE_SEARCH("r4.8xlarge.search"),

    R4_16_XLARGE_SEARCH("r4.16xlarge.search"),

    I3_LARGE_SEARCH("i3.large.search"),

    I3_XLARGE_SEARCH("i3.xlarge.search"),

    I3_2_XLARGE_SEARCH("i3.2xlarge.search"),

    I3_4_XLARGE_SEARCH("i3.4xlarge.search"),

    I3_8_XLARGE_SEARCH("i3.8xlarge.search"),

    I3_16_XLARGE_SEARCH("i3.16xlarge.search"),

    R6_G_LARGE_SEARCH("r6g.large.search"),

    R6_G_XLARGE_SEARCH("r6g.xlarge.search"),

    R6_G_2_XLARGE_SEARCH("r6g.2xlarge.search"),

    R6_G_4_XLARGE_SEARCH("r6g.4xlarge.search"),

    R6_G_8_XLARGE_SEARCH("r6g.8xlarge.search"),

    R6_G_12_XLARGE_SEARCH("r6g.12xlarge.search"),

    M6_G_LARGE_SEARCH("m6g.large.search"),

    M6_G_XLARGE_SEARCH("m6g.xlarge.search"),

    M6_G_2_XLARGE_SEARCH("m6g.2xlarge.search"),

    M6_G_4_XLARGE_SEARCH("m6g.4xlarge.search"),

    M6_G_8_XLARGE_SEARCH("m6g.8xlarge.search"),

    M6_G_12_XLARGE_SEARCH("m6g.12xlarge.search"),

    C6_G_LARGE_SEARCH("c6g.large.search"),

    C6_G_XLARGE_SEARCH("c6g.xlarge.search"),

    C6_G_2_XLARGE_SEARCH("c6g.2xlarge.search"),

    C6_G_4_XLARGE_SEARCH("c6g.4xlarge.search"),

    C6_G_8_XLARGE_SEARCH("c6g.8xlarge.search"),

    C6_G_12_XLARGE_SEARCH("c6g.12xlarge.search"),

    R6_GD_LARGE_SEARCH("r6gd.large.search"),

    R6_GD_XLARGE_SEARCH("r6gd.xlarge.search"),

    R6_GD_2_XLARGE_SEARCH("r6gd.2xlarge.search"),

    R6_GD_4_XLARGE_SEARCH("r6gd.4xlarge.search"),

    R6_GD_8_XLARGE_SEARCH("r6gd.8xlarge.search"),

    R6_GD_12_XLARGE_SEARCH("r6gd.12xlarge.search"),

    R6_GD_16_XLARGE_SEARCH("r6gd.16xlarge.search"),

    T4_G_SMALL_SEARCH("t4g.small.search"),

    T4_G_MEDIUM_SEARCH("t4g.medium.search"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OpenSearchPartitionInstanceType> VALUE_MAP = EnumUtils.uniqueIndex(
            OpenSearchPartitionInstanceType.class, OpenSearchPartitionInstanceType::toString);

    private final String value;

    private OpenSearchPartitionInstanceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return OpenSearchPartitionInstanceType corresponding to the value
     */
    public static OpenSearchPartitionInstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link OpenSearchPartitionInstanceType}s
     */
    public static Set<OpenSearchPartitionInstanceType> knownValues() {
        Set<OpenSearchPartitionInstanceType> knownValues = EnumSet.allOf(OpenSearchPartitionInstanceType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
