/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInstanceTypeDetailsRequest extends OpenSearchRequest implements
        ToCopyableBuilder<ListInstanceTypeDetailsRequest.Builder, ListInstanceTypeDetailsRequest> {
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(ListInstanceTypeDetailsRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EngineVersion").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(ListInstanceTypeDetailsRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domainName").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListInstanceTypeDetailsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInstanceTypeDetailsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Boolean> RETRIEVE_A_ZS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RetrieveAZs").getter(getter(ListInstanceTypeDetailsRequest::retrieveAZs))
            .setter(setter(Builder::retrieveAZs))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("retrieveAZs").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(ListInstanceTypeDetailsRequest::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("instanceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_VERSION_FIELD,
            DOMAIN_NAME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, RETRIEVE_A_ZS_FIELD, INSTANCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String engineVersion;

    private final String domainName;

    private final Integer maxResults;

    private final String nextToken;

    private final Boolean retrieveAZs;

    private final String instanceType;

    private ListInstanceTypeDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.engineVersion = builder.engineVersion;
        this.domainName = builder.domainName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.retrieveAZs = builder.retrieveAZs;
        this.instanceType = builder.instanceType;
    }

    /**
     * <p>
     * The version of OpenSearch or Elasticsearch, in the format Elasticsearch_X.Y or OpenSearch_X.Y. Defaults to the
     * latest version of OpenSearch.
     * </p>
     * 
     * @return The version of OpenSearch or Elasticsearch, in the format Elasticsearch_X.Y or OpenSearch_X.Y. Defaults
     *         to the latest version of OpenSearch.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The name of the domain.
     * </p>
     * 
     * @return The name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code>
     * to get the next page of results.
     * </p>
     * 
     * @return An optional parameter that specifies the maximum number of results to return. You can use
     *         <code>nextToken</code> to get the next page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If your initial <code>ListInstanceTypeDetails</code> operation returns a <code>nextToken</code>, you can include
     * the returned <code>nextToken</code> in subsequent <code>ListInstanceTypeDetails</code> operations, which returns
     * results in the next page.
     * </p>
     * 
     * @return If your initial <code>ListInstanceTypeDetails</code> operation returns a <code>nextToken</code>, you can
     *         include the returned <code>nextToken</code> in subsequent <code>ListInstanceTypeDetails</code>
     *         operations, which returns results in the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * An optional parameter that specifies the Availability Zones for the domain.
     * </p>
     * 
     * @return An optional parameter that specifies the Availability Zones for the domain.
     */
    public final Boolean retrieveAZs() {
        return retrieveAZs;
    }

    /**
     * <p>
     * An optional parameter that lists information for a given instance type.
     * </p>
     * 
     * @return An optional parameter that lists information for a given instance type.
     */
    public final String instanceType() {
        return instanceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(retrieveAZs());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceTypeDetailsRequest)) {
            return false;
        }
        ListInstanceTypeDetailsRequest other = (ListInstanceTypeDetailsRequest) obj;
        return Objects.equals(engineVersion(), other.engineVersion()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(retrieveAZs(), other.retrieveAZs()) && Objects.equals(instanceType(), other.instanceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInstanceTypeDetailsRequest").add("EngineVersion", engineVersion())
                .add("DomainName", domainName()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("RetrieveAZs", retrieveAZs()).add("InstanceType", instanceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RetrieveAZs":
            return Optional.ofNullable(clazz.cast(retrieveAZs()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("retrieveAZs", RETRIEVE_A_ZS_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInstanceTypeDetailsRequest, T> g) {
        return obj -> g.apply((ListInstanceTypeDetailsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListInstanceTypeDetailsRequest> {
        /**
         * <p>
         * The version of OpenSearch or Elasticsearch, in the format Elasticsearch_X.Y or OpenSearch_X.Y. Defaults to
         * the latest version of OpenSearch.
         * </p>
         * 
         * @param engineVersion
         *        The version of OpenSearch or Elasticsearch, in the format Elasticsearch_X.Y or OpenSearch_X.Y.
         *        Defaults to the latest version of OpenSearch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param domainName
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * An optional parameter that specifies the maximum number of results to return. You can use
         * <code>nextToken</code> to get the next page of results.
         * </p>
         * 
         * @param maxResults
         *        An optional parameter that specifies the maximum number of results to return. You can use
         *        <code>nextToken</code> to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If your initial <code>ListInstanceTypeDetails</code> operation returns a <code>nextToken</code>, you can
         * include the returned <code>nextToken</code> in subsequent <code>ListInstanceTypeDetails</code> operations,
         * which returns results in the next page.
         * </p>
         * 
         * @param nextToken
         *        If your initial <code>ListInstanceTypeDetails</code> operation returns a <code>nextToken</code>, you
         *        can include the returned <code>nextToken</code> in subsequent <code>ListInstanceTypeDetails</code>
         *        operations, which returns results in the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An optional parameter that specifies the Availability Zones for the domain.
         * </p>
         * 
         * @param retrieveAZs
         *        An optional parameter that specifies the Availability Zones for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieveAZs(Boolean retrieveAZs);

        /**
         * <p>
         * An optional parameter that lists information for a given instance type.
         * </p>
         * 
         * @param instanceType
         *        An optional parameter that lists information for a given instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private String engineVersion;

        private String domainName;

        private Integer maxResults;

        private String nextToken;

        private Boolean retrieveAZs;

        private String instanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceTypeDetailsRequest model) {
            super(model);
            engineVersion(model.engineVersion);
            domainName(model.domainName);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            retrieveAZs(model.retrieveAZs);
            instanceType(model.instanceType);
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getRetrieveAZs() {
            return retrieveAZs;
        }

        public final void setRetrieveAZs(Boolean retrieveAZs) {
            this.retrieveAZs = retrieveAZs;
        }

        @Override
        public final Builder retrieveAZs(Boolean retrieveAZs) {
            this.retrieveAZs = retrieveAZs;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInstanceTypeDetailsRequest build() {
            return new ListInstanceTypeDetailsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
