/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for IAM Identity Center Options settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityCenterOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityCenterOptions.Builder, IdentityCenterOptions> {
    private static final SdkField<Boolean> ENABLED_API_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnabledAPIAccess").getter(getter(IdentityCenterOptions::enabledAPIAccess))
            .setter(setter(Builder::enabledAPIAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledAPIAccess").build()).build();

    private static final SdkField<String> IDENTITY_CENTER_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityCenterInstanceARN").getter(getter(IdentityCenterOptions::identityCenterInstanceARN))
            .setter(setter(Builder::identityCenterInstanceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterInstanceARN").build())
            .build();

    private static final SdkField<String> SUBJECT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubjectKey").getter(getter(IdentityCenterOptions::subjectKeyAsString))
            .setter(setter(Builder::subjectKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectKey").build()).build();

    private static final SdkField<String> ROLES_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RolesKey").getter(getter(IdentityCenterOptions::rolesKeyAsString)).setter(setter(Builder::rolesKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RolesKey").build()).build();

    private static final SdkField<String> IDENTITY_CENTER_APPLICATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdentityCenterApplicationARN")
            .getter(getter(IdentityCenterOptions::identityCenterApplicationARN))
            .setter(setter(Builder::identityCenterApplicationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterApplicationARN")
                    .build()).build();

    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityStoreId").getter(getter(IdentityCenterOptions::identityStoreId))
            .setter(setter(Builder::identityStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityStoreId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_API_ACCESS_FIELD,
            IDENTITY_CENTER_INSTANCE_ARN_FIELD, SUBJECT_KEY_FIELD, ROLES_KEY_FIELD, IDENTITY_CENTER_APPLICATION_ARN_FIELD,
            IDENTITY_STORE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabledAPIAccess;

    private final String identityCenterInstanceARN;

    private final String subjectKey;

    private final String rolesKey;

    private final String identityCenterApplicationARN;

    private final String identityStoreId;

    private IdentityCenterOptions(BuilderImpl builder) {
        this.enabledAPIAccess = builder.enabledAPIAccess;
        this.identityCenterInstanceARN = builder.identityCenterInstanceARN;
        this.subjectKey = builder.subjectKey;
        this.rolesKey = builder.rolesKey;
        this.identityCenterApplicationARN = builder.identityCenterApplicationARN;
        this.identityStoreId = builder.identityStoreId;
    }

    /**
     * <p>
     * True to enable IAM Identity Center for API access in Amazon OpenSearch Service.
     * </p>
     * 
     * @return True to enable IAM Identity Center for API access in Amazon OpenSearch Service.
     */
    public final Boolean enabledAPIAccess() {
        return enabledAPIAccess;
    }

    /**
     * <p>
     * The ARN for IAM Identity Center Instance.
     * </p>
     * 
     * @return The ARN for IAM Identity Center Instance.
     */
    public final String identityCenterInstanceARN() {
        return identityCenterInstanceARN;
    }

    /**
     * <p>
     * Specify the attribute that contains the subject (username, userID, email) of IAM Identity Center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subjectKey} will
     * return {@link SubjectKeyIdCOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #subjectKeyAsString}.
     * </p>
     * 
     * @return Specify the attribute that contains the subject (username, userID, email) of IAM Identity Center.
     * @see SubjectKeyIdCOption
     */
    public final SubjectKeyIdCOption subjectKey() {
        return SubjectKeyIdCOption.fromValue(subjectKey);
    }

    /**
     * <p>
     * Specify the attribute that contains the subject (username, userID, email) of IAM Identity Center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subjectKey} will
     * return {@link SubjectKeyIdCOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #subjectKeyAsString}.
     * </p>
     * 
     * @return Specify the attribute that contains the subject (username, userID, email) of IAM Identity Center.
     * @see SubjectKeyIdCOption
     */
    public final String subjectKeyAsString() {
        return subjectKey;
    }

    /**
     * <p>
     * Specify the attribute that contains the backend role (groupName, groupID) of IAM Identity Center
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rolesKey} will
     * return {@link RolesKeyIdCOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rolesKeyAsString}.
     * </p>
     * 
     * @return Specify the attribute that contains the backend role (groupName, groupID) of IAM Identity Center
     * @see RolesKeyIdCOption
     */
    public final RolesKeyIdCOption rolesKey() {
        return RolesKeyIdCOption.fromValue(rolesKey);
    }

    /**
     * <p>
     * Specify the attribute that contains the backend role (groupName, groupID) of IAM Identity Center
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rolesKey} will
     * return {@link RolesKeyIdCOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rolesKeyAsString}.
     * </p>
     * 
     * @return Specify the attribute that contains the backend role (groupName, groupID) of IAM Identity Center
     * @see RolesKeyIdCOption
     */
    public final String rolesKeyAsString() {
        return rolesKey;
    }

    /**
     * <p>
     * The ARN for IAM Identity Center Application which will integrate with Amazon OpenSearch Service.
     * </p>
     * 
     * @return The ARN for IAM Identity Center Application which will integrate with Amazon OpenSearch Service.
     */
    public final String identityCenterApplicationARN() {
        return identityCenterApplicationARN;
    }

    /**
     * <p>
     * The ID of IAM Identity Store.
     * </p>
     * 
     * @return The ID of IAM Identity Store.
     */
    public final String identityStoreId() {
        return identityStoreId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabledAPIAccess());
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterInstanceARN());
        hashCode = 31 * hashCode + Objects.hashCode(subjectKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rolesKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterApplicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(identityStoreId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityCenterOptions)) {
            return false;
        }
        IdentityCenterOptions other = (IdentityCenterOptions) obj;
        return Objects.equals(enabledAPIAccess(), other.enabledAPIAccess())
                && Objects.equals(identityCenterInstanceARN(), other.identityCenterInstanceARN())
                && Objects.equals(subjectKeyAsString(), other.subjectKeyAsString())
                && Objects.equals(rolesKeyAsString(), other.rolesKeyAsString())
                && Objects.equals(identityCenterApplicationARN(), other.identityCenterApplicationARN())
                && Objects.equals(identityStoreId(), other.identityStoreId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityCenterOptions").add("EnabledAPIAccess", enabledAPIAccess())
                .add("IdentityCenterInstanceARN", identityCenterInstanceARN()).add("SubjectKey", subjectKeyAsString())
                .add("RolesKey", rolesKeyAsString()).add("IdentityCenterApplicationARN", identityCenterApplicationARN())
                .add("IdentityStoreId", identityStoreId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnabledAPIAccess":
            return Optional.ofNullable(clazz.cast(enabledAPIAccess()));
        case "IdentityCenterInstanceARN":
            return Optional.ofNullable(clazz.cast(identityCenterInstanceARN()));
        case "SubjectKey":
            return Optional.ofNullable(clazz.cast(subjectKeyAsString()));
        case "RolesKey":
            return Optional.ofNullable(clazz.cast(rolesKeyAsString()));
        case "IdentityCenterApplicationARN":
            return Optional.ofNullable(clazz.cast(identityCenterApplicationARN()));
        case "IdentityStoreId":
            return Optional.ofNullable(clazz.cast(identityStoreId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnabledAPIAccess", ENABLED_API_ACCESS_FIELD);
        map.put("IdentityCenterInstanceARN", IDENTITY_CENTER_INSTANCE_ARN_FIELD);
        map.put("SubjectKey", SUBJECT_KEY_FIELD);
        map.put("RolesKey", ROLES_KEY_FIELD);
        map.put("IdentityCenterApplicationARN", IDENTITY_CENTER_APPLICATION_ARN_FIELD);
        map.put("IdentityStoreId", IDENTITY_STORE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentityCenterOptions, T> g) {
        return obj -> g.apply((IdentityCenterOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityCenterOptions> {
        /**
         * <p>
         * True to enable IAM Identity Center for API access in Amazon OpenSearch Service.
         * </p>
         * 
         * @param enabledAPIAccess
         *        True to enable IAM Identity Center for API access in Amazon OpenSearch Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledAPIAccess(Boolean enabledAPIAccess);

        /**
         * <p>
         * The ARN for IAM Identity Center Instance.
         * </p>
         * 
         * @param identityCenterInstanceARN
         *        The ARN for IAM Identity Center Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterInstanceARN(String identityCenterInstanceARN);

        /**
         * <p>
         * Specify the attribute that contains the subject (username, userID, email) of IAM Identity Center.
         * </p>
         * 
         * @param subjectKey
         *        Specify the attribute that contains the subject (username, userID, email) of IAM Identity Center.
         * @see SubjectKeyIdCOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubjectKeyIdCOption
         */
        Builder subjectKey(String subjectKey);

        /**
         * <p>
         * Specify the attribute that contains the subject (username, userID, email) of IAM Identity Center.
         * </p>
         * 
         * @param subjectKey
         *        Specify the attribute that contains the subject (username, userID, email) of IAM Identity Center.
         * @see SubjectKeyIdCOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubjectKeyIdCOption
         */
        Builder subjectKey(SubjectKeyIdCOption subjectKey);

        /**
         * <p>
         * Specify the attribute that contains the backend role (groupName, groupID) of IAM Identity Center
         * </p>
         * 
         * @param rolesKey
         *        Specify the attribute that contains the backend role (groupName, groupID) of IAM Identity Center
         * @see RolesKeyIdCOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RolesKeyIdCOption
         */
        Builder rolesKey(String rolesKey);

        /**
         * <p>
         * Specify the attribute that contains the backend role (groupName, groupID) of IAM Identity Center
         * </p>
         * 
         * @param rolesKey
         *        Specify the attribute that contains the backend role (groupName, groupID) of IAM Identity Center
         * @see RolesKeyIdCOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RolesKeyIdCOption
         */
        Builder rolesKey(RolesKeyIdCOption rolesKey);

        /**
         * <p>
         * The ARN for IAM Identity Center Application which will integrate with Amazon OpenSearch Service.
         * </p>
         * 
         * @param identityCenterApplicationARN
         *        The ARN for IAM Identity Center Application which will integrate with Amazon OpenSearch Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterApplicationARN(String identityCenterApplicationARN);

        /**
         * <p>
         * The ID of IAM Identity Store.
         * </p>
         * 
         * @param identityStoreId
         *        The ID of IAM Identity Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityStoreId(String identityStoreId);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabledAPIAccess;

        private String identityCenterInstanceARN;

        private String subjectKey;

        private String rolesKey;

        private String identityCenterApplicationARN;

        private String identityStoreId;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityCenterOptions model) {
            enabledAPIAccess(model.enabledAPIAccess);
            identityCenterInstanceARN(model.identityCenterInstanceARN);
            subjectKey(model.subjectKey);
            rolesKey(model.rolesKey);
            identityCenterApplicationARN(model.identityCenterApplicationARN);
            identityStoreId(model.identityStoreId);
        }

        public final Boolean getEnabledAPIAccess() {
            return enabledAPIAccess;
        }

        public final void setEnabledAPIAccess(Boolean enabledAPIAccess) {
            this.enabledAPIAccess = enabledAPIAccess;
        }

        @Override
        public final Builder enabledAPIAccess(Boolean enabledAPIAccess) {
            this.enabledAPIAccess = enabledAPIAccess;
            return this;
        }

        public final String getIdentityCenterInstanceARN() {
            return identityCenterInstanceARN;
        }

        public final void setIdentityCenterInstanceARN(String identityCenterInstanceARN) {
            this.identityCenterInstanceARN = identityCenterInstanceARN;
        }

        @Override
        public final Builder identityCenterInstanceARN(String identityCenterInstanceARN) {
            this.identityCenterInstanceARN = identityCenterInstanceARN;
            return this;
        }

        public final String getSubjectKey() {
            return subjectKey;
        }

        public final void setSubjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
        }

        @Override
        public final Builder subjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
            return this;
        }

        @Override
        public final Builder subjectKey(SubjectKeyIdCOption subjectKey) {
            this.subjectKey(subjectKey == null ? null : subjectKey.toString());
            return this;
        }

        public final String getRolesKey() {
            return rolesKey;
        }

        public final void setRolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
        }

        @Override
        public final Builder rolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
            return this;
        }

        @Override
        public final Builder rolesKey(RolesKeyIdCOption rolesKey) {
            this.rolesKey(rolesKey == null ? null : rolesKey.toString());
            return this;
        }

        public final String getIdentityCenterApplicationARN() {
            return identityCenterApplicationARN;
        }

        public final void setIdentityCenterApplicationARN(String identityCenterApplicationARN) {
            this.identityCenterApplicationARN = identityCenterApplicationARN;
        }

        @Override
        public final Builder identityCenterApplicationARN(String identityCenterApplicationARN) {
            this.identityCenterApplicationARN = identityCenterApplicationARN;
            return this;
        }

        public final String getIdentityStoreId() {
            return identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        @Override
        public IdentityCenterOptions build() {
            return new IdentityCenterOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
