/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationResponse extends OpenSearchResponse implements
        ToCopyableBuilder<GetApplicationResponse.Builder, GetApplicationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetApplicationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetApplicationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetApplicationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(GetApplicationResponse::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetApplicationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<IamIdentityCenterOptions> IAM_IDENTITY_CENTER_OPTIONS_FIELD = SdkField
            .<IamIdentityCenterOptions> builder(MarshallingType.SDK_POJO).memberName("iamIdentityCenterOptions")
            .getter(getter(GetApplicationResponse::iamIdentityCenterOptions)).setter(setter(Builder::iamIdentityCenterOptions))
            .constructor(IamIdentityCenterOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamIdentityCenterOptions").build())
            .build();

    private static final SdkField<List<DataSource>> DATA_SOURCES_FIELD = SdkField
            .<List<DataSource>> builder(MarshallingType.LIST)
            .memberName("dataSources")
            .getter(getter(GetApplicationResponse::dataSources))
            .setter(setter(Builder::dataSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AppConfig>> APP_CONFIGS_FIELD = SdkField
            .<List<AppConfig>> builder(MarshallingType.LIST)
            .memberName("appConfigs")
            .getter(getter(GetApplicationResponse::appConfigs))
            .setter(setter(Builder::appConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetApplicationResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(GetApplicationResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, ENDPOINT_FIELD, STATUS_FIELD, IAM_IDENTITY_CENTER_OPTIONS_FIELD, DATA_SOURCES_FIELD, APP_CONFIGS_FIELD,
            CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String arn;

    private final String name;

    private final String endpoint;

    private final String status;

    private final IamIdentityCenterOptions iamIdentityCenterOptions;

    private final List<DataSource> dataSources;

    private final List<AppConfig> appConfigs;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private GetApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.endpoint = builder.endpoint;
        this.status = builder.status;
        this.iamIdentityCenterOptions = builder.iamIdentityCenterOptions;
        this.dataSources = builder.dataSources;
        this.appConfigs = builder.appConfigs;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * Unique identifier of the checked OpenSearch Application.
     * </p>
     * 
     * @return Unique identifier of the checked OpenSearch Application.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the Arn property for this object.
     * 
     * @return The value of the Arn property for this object.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Name of the checked OpenSearch Application.
     * </p>
     * 
     * @return Name of the checked OpenSearch Application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Endpoint URL of the checked OpenSearch Application.
     * </p>
     * 
     * @return Endpoint URL of the checked OpenSearch Application.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * Current status of the checked OpenSearch Application. Possible values are <code>CREATING</code>,
     * <code>UPDATING</code>, <code>DELETING</code>, <code>FAILED</code>, <code>ACTIVE</code>, and <code>DELETED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Current status of the checked OpenSearch Application. Possible values are <code>CREATING</code>,
     *         <code>UPDATING</code>, <code>DELETING</code>, <code>FAILED</code>, <code>ACTIVE</code>, and
     *         <code>DELETED</code>.
     * @see ApplicationStatus
     */
    public final ApplicationStatus status() {
        return ApplicationStatus.fromValue(status);
    }

    /**
     * <p>
     * Current status of the checked OpenSearch Application. Possible values are <code>CREATING</code>,
     * <code>UPDATING</code>, <code>DELETING</code>, <code>FAILED</code>, <code>ACTIVE</code>, and <code>DELETED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Current status of the checked OpenSearch Application. Possible values are <code>CREATING</code>,
     *         <code>UPDATING</code>, <code>DELETING</code>, <code>FAILED</code>, <code>ACTIVE</code>, and
     *         <code>DELETED</code>.
     * @see ApplicationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * IAM Identity Center settings for the checked OpenSearch Application.
     * </p>
     * 
     * @return IAM Identity Center settings for the checked OpenSearch Application.
     */
    public final IamIdentityCenterOptions iamIdentityCenterOptions() {
        return iamIdentityCenterOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataSources() {
        return dataSources != null && !(dataSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Associated data sources to the checked OpenSearch Application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSources} method.
     * </p>
     * 
     * @return Associated data sources to the checked OpenSearch Application.
     */
    public final List<DataSource> dataSources() {
        return dataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppConfigs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAppConfigs() {
        return appConfigs != null && !(appConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * App configurations of the checked OpenSearch Application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppConfigs} method.
     * </p>
     * 
     * @return App configurations of the checked OpenSearch Application.
     */
    public final List<AppConfig> appConfigs() {
        return appConfigs;
    }

    /**
     * <p>
     * Timestamp at which the checked OpenSearch Application was created.
     * </p>
     * 
     * @return Timestamp at which the checked OpenSearch Application was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Timestamp at which the checked OpenSearch Application was last updated.
     * </p>
     * 
     * @return Timestamp at which the checked OpenSearch Application was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(iamIdentityCenterOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSources() ? dataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAppConfigs() ? appConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationResponse)) {
            return false;
        }
        GetApplicationResponse other = (GetApplicationResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(endpoint(), other.endpoint()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(iamIdentityCenterOptions(), other.iamIdentityCenterOptions())
                && hasDataSources() == other.hasDataSources() && Objects.equals(dataSources(), other.dataSources())
                && hasAppConfigs() == other.hasAppConfigs() && Objects.equals(appConfigs(), other.appConfigs())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationResponse").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("Endpoint", endpoint()).add("Status", statusAsString())
                .add("IamIdentityCenterOptions", iamIdentityCenterOptions())
                .add("DataSources", hasDataSources() ? dataSources() : null)
                .add("AppConfigs", hasAppConfigs() ? appConfigs() : null).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "iamIdentityCenterOptions":
            return Optional.ofNullable(clazz.cast(iamIdentityCenterOptions()));
        case "dataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "appConfigs":
            return Optional.ofNullable(clazz.cast(appConfigs()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("iamIdentityCenterOptions", IAM_IDENTITY_CENTER_OPTIONS_FIELD);
        map.put("dataSources", DATA_SOURCES_FIELD);
        map.put("appConfigs", APP_CONFIGS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationResponse, T> g) {
        return obj -> g.apply((GetApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetApplicationResponse> {
        /**
         * <p>
         * Unique identifier of the checked OpenSearch Application.
         * </p>
         * 
         * @param id
         *        Unique identifier of the checked OpenSearch Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the Arn property for this object.
         *
         * @param arn
         *        The new value for the Arn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Name of the checked OpenSearch Application.
         * </p>
         * 
         * @param name
         *        Name of the checked OpenSearch Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Endpoint URL of the checked OpenSearch Application.
         * </p>
         * 
         * @param endpoint
         *        Endpoint URL of the checked OpenSearch Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * Current status of the checked OpenSearch Application. Possible values are <code>CREATING</code>,
         * <code>UPDATING</code>, <code>DELETING</code>, <code>FAILED</code>, <code>ACTIVE</code>, and
         * <code>DELETED</code>.
         * </p>
         * 
         * @param status
         *        Current status of the checked OpenSearch Application. Possible values are <code>CREATING</code>,
         *        <code>UPDATING</code>, <code>DELETING</code>, <code>FAILED</code>, <code>ACTIVE</code>, and
         *        <code>DELETED</code>.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Current status of the checked OpenSearch Application. Possible values are <code>CREATING</code>,
         * <code>UPDATING</code>, <code>DELETING</code>, <code>FAILED</code>, <code>ACTIVE</code>, and
         * <code>DELETED</code>.
         * </p>
         * 
         * @param status
         *        Current status of the checked OpenSearch Application. Possible values are <code>CREATING</code>,
         *        <code>UPDATING</code>, <code>DELETING</code>, <code>FAILED</code>, <code>ACTIVE</code>, and
         *        <code>DELETED</code>.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(ApplicationStatus status);

        /**
         * <p>
         * IAM Identity Center settings for the checked OpenSearch Application.
         * </p>
         * 
         * @param iamIdentityCenterOptions
         *        IAM Identity Center settings for the checked OpenSearch Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamIdentityCenterOptions(IamIdentityCenterOptions iamIdentityCenterOptions);

        /**
         * <p>
         * IAM Identity Center settings for the checked OpenSearch Application.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamIdentityCenterOptions.Builder}
         * avoiding the need to create one manually via {@link IamIdentityCenterOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamIdentityCenterOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #iamIdentityCenterOptions(IamIdentityCenterOptions)}.
         * 
         * @param iamIdentityCenterOptions
         *        a consumer that will call methods on {@link IamIdentityCenterOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamIdentityCenterOptions(IamIdentityCenterOptions)
         */
        default Builder iamIdentityCenterOptions(Consumer<IamIdentityCenterOptions.Builder> iamIdentityCenterOptions) {
            return iamIdentityCenterOptions(IamIdentityCenterOptions.builder().applyMutation(iamIdentityCenterOptions).build());
        }

        /**
         * <p>
         * Associated data sources to the checked OpenSearch Application.
         * </p>
         * 
         * @param dataSources
         *        Associated data sources to the checked OpenSearch Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(Collection<DataSource> dataSources);

        /**
         * <p>
         * Associated data sources to the checked OpenSearch Application.
         * </p>
         * 
         * @param dataSources
         *        Associated data sources to the checked OpenSearch Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(DataSource... dataSources);

        /**
         * <p>
         * Associated data sources to the checked OpenSearch Application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.DataSource.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.opensearch.model.DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.DataSource.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSources(List<DataSource>)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(java.util.Collection<DataSource>)
         */
        Builder dataSources(Consumer<DataSource.Builder>... dataSources);

        /**
         * <p>
         * App configurations of the checked OpenSearch Application.
         * </p>
         * 
         * @param appConfigs
         *        App configurations of the checked OpenSearch Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appConfigs(Collection<AppConfig> appConfigs);

        /**
         * <p>
         * App configurations of the checked OpenSearch Application.
         * </p>
         * 
         * @param appConfigs
         *        App configurations of the checked OpenSearch Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appConfigs(AppConfig... appConfigs);

        /**
         * <p>
         * App configurations of the checked OpenSearch Application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.AppConfig.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.opensearch.model.AppConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.AppConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #appConfigs(List<AppConfig>)}.
         * 
         * @param appConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.AppConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appConfigs(java.util.Collection<AppConfig>)
         */
        Builder appConfigs(Consumer<AppConfig.Builder>... appConfigs);

        /**
         * <p>
         * Timestamp at which the checked OpenSearch Application was created.
         * </p>
         * 
         * @param createdAt
         *        Timestamp at which the checked OpenSearch Application was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Timestamp at which the checked OpenSearch Application was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        Timestamp at which the checked OpenSearch Application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String endpoint;

        private String status;

        private IamIdentityCenterOptions iamIdentityCenterOptions;

        private List<DataSource> dataSources = DefaultSdkAutoConstructList.getInstance();

        private List<AppConfig> appConfigs = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            name(model.name);
            endpoint(model.endpoint);
            status(model.status);
            iamIdentityCenterOptions(model.iamIdentityCenterOptions);
            dataSources(model.dataSources);
            appConfigs(model.appConfigs);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final IamIdentityCenterOptions.Builder getIamIdentityCenterOptions() {
            return iamIdentityCenterOptions != null ? iamIdentityCenterOptions.toBuilder() : null;
        }

        public final void setIamIdentityCenterOptions(IamIdentityCenterOptions.BuilderImpl iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions != null ? iamIdentityCenterOptions.build() : null;
        }

        @Override
        public final Builder iamIdentityCenterOptions(IamIdentityCenterOptions iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions;
            return this;
        }

        public final List<DataSource.Builder> getDataSources() {
            List<DataSource.Builder> result = DataSourcesCopier.copyToBuilder(this.dataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSources(Collection<DataSource.BuilderImpl> dataSources) {
            this.dataSources = DataSourcesCopier.copyFromBuilder(dataSources);
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource... dataSources) {
            dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<DataSource.Builder>... dataSources) {
            dataSources(Stream.of(dataSources).map(c -> DataSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AppConfig.Builder> getAppConfigs() {
            List<AppConfig.Builder> result = AppConfigsCopier.copyToBuilder(this.appConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppConfigs(Collection<AppConfig.BuilderImpl> appConfigs) {
            this.appConfigs = AppConfigsCopier.copyFromBuilder(appConfigs);
        }

        @Override
        public final Builder appConfigs(Collection<AppConfig> appConfigs) {
            this.appConfigs = AppConfigsCopier.copy(appConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appConfigs(AppConfig... appConfigs) {
            appConfigs(Arrays.asList(appConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appConfigs(Consumer<AppConfig.Builder>... appConfigs) {
            appConfigs(Stream.of(appConfigs).map(c -> AppConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public GetApplicationResponse build() {
            return new GetApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
