/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDryRunProgressRequest extends OpenSearchRequest implements
        ToCopyableBuilder<DescribeDryRunProgressRequest.Builder, DescribeDryRunProgressRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DescribeDryRunProgressRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> DRY_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DryRunId").getter(getter(DescribeDryRunProgressRequest::dryRunId)).setter(setter(Builder::dryRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("dryRunId").build()).build();

    private static final SdkField<Boolean> LOAD_DRY_RUN_CONFIG_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("LoadDryRunConfig").getter(getter(DescribeDryRunProgressRequest::loadDryRunConfig))
            .setter(setter(Builder::loadDryRunConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("loadDryRunConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            DRY_RUN_ID_FIELD, LOAD_DRY_RUN_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String dryRunId;

    private final Boolean loadDryRunConfig;

    private DescribeDryRunProgressRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.dryRunId = builder.dryRunId;
        this.loadDryRunConfig = builder.loadDryRunConfig;
    }

    /**
     * <p>
     * The name of the domain.
     * </p>
     * 
     * @return The name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The unique identifier of the dry run.
     * </p>
     * 
     * @return The unique identifier of the dry run.
     */
    public final String dryRunId() {
        return dryRunId;
    }

    /**
     * <p>
     * Whether to include the configuration of the dry run in the response. The configuration specifies the updates that
     * you're planning to make on the domain.
     * </p>
     * 
     * @return Whether to include the configuration of the dry run in the response. The configuration specifies the
     *         updates that you're planning to make on the domain.
     */
    public final Boolean loadDryRunConfig() {
        return loadDryRunConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(dryRunId());
        hashCode = 31 * hashCode + Objects.hashCode(loadDryRunConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDryRunProgressRequest)) {
            return false;
        }
        DescribeDryRunProgressRequest other = (DescribeDryRunProgressRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(dryRunId(), other.dryRunId())
                && Objects.equals(loadDryRunConfig(), other.loadDryRunConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDryRunProgressRequest").add("DomainName", domainName()).add("DryRunId", dryRunId())
                .add("LoadDryRunConfig", loadDryRunConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "DryRunId":
            return Optional.ofNullable(clazz.cast(dryRunId()));
        case "LoadDryRunConfig":
            return Optional.ofNullable(clazz.cast(loadDryRunConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("dryRunId", DRY_RUN_ID_FIELD);
        map.put("loadDryRunConfig", LOAD_DRY_RUN_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDryRunProgressRequest, T> g) {
        return obj -> g.apply((DescribeDryRunProgressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDryRunProgressRequest> {
        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param domainName
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The unique identifier of the dry run.
         * </p>
         * 
         * @param dryRunId
         *        The unique identifier of the dry run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRunId(String dryRunId);

        /**
         * <p>
         * Whether to include the configuration of the dry run in the response. The configuration specifies the updates
         * that you're planning to make on the domain.
         * </p>
         * 
         * @param loadDryRunConfig
         *        Whether to include the configuration of the dry run in the response. The configuration specifies the
         *        updates that you're planning to make on the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadDryRunConfig(Boolean loadDryRunConfig);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private String domainName;

        private String dryRunId;

        private Boolean loadDryRunConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDryRunProgressRequest model) {
            super(model);
            domainName(model.domainName);
            dryRunId(model.dryRunId);
            loadDryRunConfig(model.loadDryRunConfig);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDryRunId() {
            return dryRunId;
        }

        public final void setDryRunId(String dryRunId) {
            this.dryRunId = dryRunId;
        }

        @Override
        public final Builder dryRunId(String dryRunId) {
            this.dryRunId = dryRunId;
            return this;
        }

        public final Boolean getLoadDryRunConfig() {
            return loadDryRunConfig;
        }

        public final void setLoadDryRunConfig(Boolean loadDryRunConfig) {
            this.loadDryRunConfig = loadDryRunConfig;
        }

        @Override
        public final Builder loadDryRunConfig(Boolean loadDryRunConfig) {
            this.loadDryRunConfig = loadDryRunConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDryRunProgressRequest build() {
            return new DescribeDryRunProgressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
