/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Cross-cluster search specific connection properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CrossClusterSearchConnectionProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<CrossClusterSearchConnectionProperties.Builder, CrossClusterSearchConnectionProperties> {
    private static final SdkField<String> SKIP_UNAVAILABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SkipUnavailable").getter(getter(CrossClusterSearchConnectionProperties::skipUnavailableAsString))
            .setter(setter(Builder::skipUnavailable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipUnavailable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKIP_UNAVAILABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String skipUnavailable;

    private CrossClusterSearchConnectionProperties(BuilderImpl builder) {
        this.skipUnavailable = builder.skipUnavailable;
    }

    /**
     * <p>
     * The status of the <code>SkipUnavailable</code> setting for the outbound connection. This feature allows you to
     * specify some clusters as optional and ensure that your cross-cluster queries return partial results despite
     * failures on one or more remote clusters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #skipUnavailable}
     * will return {@link SkipUnavailableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #skipUnavailableAsString}.
     * </p>
     * 
     * @return The status of the <code>SkipUnavailable</code> setting for the outbound connection. This feature allows
     *         you to specify some clusters as optional and ensure that your cross-cluster queries return partial
     *         results despite failures on one or more remote clusters.
     * @see SkipUnavailableStatus
     */
    public final SkipUnavailableStatus skipUnavailable() {
        return SkipUnavailableStatus.fromValue(skipUnavailable);
    }

    /**
     * <p>
     * The status of the <code>SkipUnavailable</code> setting for the outbound connection. This feature allows you to
     * specify some clusters as optional and ensure that your cross-cluster queries return partial results despite
     * failures on one or more remote clusters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #skipUnavailable}
     * will return {@link SkipUnavailableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #skipUnavailableAsString}.
     * </p>
     * 
     * @return The status of the <code>SkipUnavailable</code> setting for the outbound connection. This feature allows
     *         you to specify some clusters as optional and ensure that your cross-cluster queries return partial
     *         results despite failures on one or more remote clusters.
     * @see SkipUnavailableStatus
     */
    public final String skipUnavailableAsString() {
        return skipUnavailable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skipUnavailableAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrossClusterSearchConnectionProperties)) {
            return false;
        }
        CrossClusterSearchConnectionProperties other = (CrossClusterSearchConnectionProperties) obj;
        return Objects.equals(skipUnavailableAsString(), other.skipUnavailableAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CrossClusterSearchConnectionProperties").add("SkipUnavailable", skipUnavailableAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkipUnavailable":
            return Optional.ofNullable(clazz.cast(skipUnavailableAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SkipUnavailable", SKIP_UNAVAILABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CrossClusterSearchConnectionProperties, T> g) {
        return obj -> g.apply((CrossClusterSearchConnectionProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CrossClusterSearchConnectionProperties> {
        /**
         * <p>
         * The status of the <code>SkipUnavailable</code> setting for the outbound connection. This feature allows you
         * to specify some clusters as optional and ensure that your cross-cluster queries return partial results
         * despite failures on one or more remote clusters.
         * </p>
         * 
         * @param skipUnavailable
         *        The status of the <code>SkipUnavailable</code> setting for the outbound connection. This feature
         *        allows you to specify some clusters as optional and ensure that your cross-cluster queries return
         *        partial results despite failures on one or more remote clusters.
         * @see SkipUnavailableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SkipUnavailableStatus
         */
        Builder skipUnavailable(String skipUnavailable);

        /**
         * <p>
         * The status of the <code>SkipUnavailable</code> setting for the outbound connection. This feature allows you
         * to specify some clusters as optional and ensure that your cross-cluster queries return partial results
         * despite failures on one or more remote clusters.
         * </p>
         * 
         * @param skipUnavailable
         *        The status of the <code>SkipUnavailable</code> setting for the outbound connection. This feature
         *        allows you to specify some clusters as optional and ensure that your cross-cluster queries return
         *        partial results despite failures on one or more remote clusters.
         * @see SkipUnavailableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SkipUnavailableStatus
         */
        Builder skipUnavailable(SkipUnavailableStatus skipUnavailable);
    }

    static final class BuilderImpl implements Builder {
        private String skipUnavailable;

        private BuilderImpl() {
        }

        private BuilderImpl(CrossClusterSearchConnectionProperties model) {
            skipUnavailable(model.skipUnavailable);
        }

        public final String getSkipUnavailable() {
            return skipUnavailable;
        }

        public final void setSkipUnavailable(String skipUnavailable) {
            this.skipUnavailable = skipUnavailable;
        }

        @Override
        public final Builder skipUnavailable(String skipUnavailable) {
            this.skipUnavailable = skipUnavailable;
            return this;
        }

        @Override
        public final Builder skipUnavailable(SkipUnavailableStatus skipUnavailable) {
            this.skipUnavailable(skipUnavailable == null ? null : skipUnavailable.toString());
            return this;
        }

        @Override
        public CrossClusterSearchConnectionProperties build() {
            return new CrossClusterSearchConnectionProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
