/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcEndpointRequest extends OpenSearchRequest implements
        ToCopyableBuilder<CreateVpcEndpointRequest.Builder, CreateVpcEndpointRequest> {
    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainArn").getter(getter(CreateVpcEndpointRequest::domainArn)).setter(setter(Builder::domainArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainArn").build()).build();

    private static final SdkField<VPCOptions> VPC_OPTIONS_FIELD = SdkField.<VPCOptions> builder(MarshallingType.SDK_POJO)
            .memberName("VpcOptions").getter(getter(CreateVpcEndpointRequest::vpcOptions)).setter(setter(Builder::vpcOptions))
            .constructor(VPCOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOptions").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreateVpcEndpointRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ARN_FIELD,
            VPC_OPTIONS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainArn;

    private final VPCOptions vpcOptions;

    private final String clientToken;

    private CreateVpcEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.domainArn = builder.domainArn;
        this.vpcOptions = builder.vpcOptions;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the domain to create the endpoint for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the domain to create the endpoint for.
     */
    public final String domainArn() {
        return domainArn;
    }

    /**
     * <p>
     * Options to specify the subnets and security groups for the endpoint.
     * </p>
     * 
     * @return Options to specify the subnets and security groups for the endpoint.
     */
    public final VPCOptions vpcOptions() {
        return vpcOptions;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier to ensure idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier to ensure idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointRequest)) {
            return false;
        }
        CreateVpcEndpointRequest other = (CreateVpcEndpointRequest) obj;
        return Objects.equals(domainArn(), other.domainArn()) && Objects.equals(vpcOptions(), other.vpcOptions())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpcEndpointRequest").add("DomainArn", domainArn()).add("VpcOptions", vpcOptions())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainArn":
            return Optional.ofNullable(clazz.cast(domainArn()));
        case "VpcOptions":
            return Optional.ofNullable(clazz.cast(vpcOptions()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainArn", DOMAIN_ARN_FIELD);
        map.put("VpcOptions", VPC_OPTIONS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointRequest, T> g) {
        return obj -> g.apply((CreateVpcEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateVpcEndpointRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the domain to create the endpoint for.
         * </p>
         * 
         * @param domainArn
         *        The Amazon Resource Name (ARN) of the domain to create the endpoint for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainArn(String domainArn);

        /**
         * <p>
         * Options to specify the subnets and security groups for the endpoint.
         * </p>
         * 
         * @param vpcOptions
         *        Options to specify the subnets and security groups for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOptions(VPCOptions vpcOptions);

        /**
         * <p>
         * Options to specify the subnets and security groups for the endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link VPCOptions.Builder} avoiding the need to
         * create one manually via {@link VPCOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VPCOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcOptions(VPCOptions)}.
         * 
         * @param vpcOptions
         *        a consumer that will call methods on {@link VPCOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOptions(VPCOptions)
         */
        default Builder vpcOptions(Consumer<VPCOptions.Builder> vpcOptions) {
            return vpcOptions(VPCOptions.builder().applyMutation(vpcOptions).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier to ensure idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier to ensure idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private String domainArn;

        private VPCOptions vpcOptions;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointRequest model) {
            super(model);
            domainArn(model.domainArn);
            vpcOptions(model.vpcOptions);
            clientToken(model.clientToken);
        }

        public final String getDomainArn() {
            return domainArn;
        }

        public final void setDomainArn(String domainArn) {
            this.domainArn = domainArn;
        }

        @Override
        public final Builder domainArn(String domainArn) {
            this.domainArn = domainArn;
            return this;
        }

        public final VPCOptions.Builder getVpcOptions() {
            return vpcOptions != null ? vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(VPCOptions.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(VPCOptions vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcEndpointRequest build() {
            return new CreateVpcEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
