/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for request parameters to the <code>CreatePackage</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePackageRequest extends OpenSearchRequest implements
        ToCopyableBuilder<CreatePackageRequest.Builder, CreatePackageRequest> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageName").getter(getter(CreatePackageRequest::packageName)).setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()).build();

    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageType").getter(getter(CreatePackageRequest::packageTypeAsString))
            .setter(setter(Builder::packageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageType").build()).build();

    private static final SdkField<String> PACKAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageDescription").getter(getter(CreatePackageRequest::packageDescription))
            .setter(setter(Builder::packageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageDescription").build())
            .build();

    private static final SdkField<PackageSource> PACKAGE_SOURCE_FIELD = SdkField
            .<PackageSource> builder(MarshallingType.SDK_POJO).memberName("PackageSource")
            .getter(getter(CreatePackageRequest::packageSource)).setter(setter(Builder::packageSource))
            .constructor(PackageSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageSource").build()).build();

    private static final SdkField<PackageConfiguration> PACKAGE_CONFIGURATION_FIELD = SdkField
            .<PackageConfiguration> builder(MarshallingType.SDK_POJO).memberName("PackageConfiguration")
            .getter(getter(CreatePackageRequest::packageConfiguration)).setter(setter(Builder::packageConfiguration))
            .constructor(PackageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageConfiguration").build())
            .build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(CreatePackageRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<PackageVendingOptions> PACKAGE_VENDING_OPTIONS_FIELD = SdkField
            .<PackageVendingOptions> builder(MarshallingType.SDK_POJO).memberName("PackageVendingOptions")
            .getter(getter(CreatePackageRequest::packageVendingOptions)).setter(setter(Builder::packageVendingOptions))
            .constructor(PackageVendingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVendingOptions").build())
            .build();

    private static final SdkField<PackageEncryptionOptions> PACKAGE_ENCRYPTION_OPTIONS_FIELD = SdkField
            .<PackageEncryptionOptions> builder(MarshallingType.SDK_POJO).memberName("PackageEncryptionOptions")
            .getter(getter(CreatePackageRequest::packageEncryptionOptions)).setter(setter(Builder::packageEncryptionOptions))
            .constructor(PackageEncryptionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageEncryptionOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD,
            PACKAGE_TYPE_FIELD, PACKAGE_DESCRIPTION_FIELD, PACKAGE_SOURCE_FIELD, PACKAGE_CONFIGURATION_FIELD,
            ENGINE_VERSION_FIELD, PACKAGE_VENDING_OPTIONS_FIELD, PACKAGE_ENCRYPTION_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String packageName;

    private final String packageType;

    private final String packageDescription;

    private final PackageSource packageSource;

    private final PackageConfiguration packageConfiguration;

    private final String engineVersion;

    private final PackageVendingOptions packageVendingOptions;

    private final PackageEncryptionOptions packageEncryptionOptions;

    private CreatePackageRequest(BuilderImpl builder) {
        super(builder);
        this.packageName = builder.packageName;
        this.packageType = builder.packageType;
        this.packageDescription = builder.packageDescription;
        this.packageSource = builder.packageSource;
        this.packageConfiguration = builder.packageConfiguration;
        this.engineVersion = builder.engineVersion;
        this.packageVendingOptions = builder.packageVendingOptions;
        this.packageEncryptionOptions = builder.packageEncryptionOptions;
    }

    /**
     * <p>
     * Unique name for the package.
     * </p>
     * 
     * @return Unique name for the package.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * The type of package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageType} will
     * return {@link PackageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageTypeAsString}.
     * </p>
     * 
     * @return The type of package.
     * @see PackageType
     */
    public final PackageType packageType() {
        return PackageType.fromValue(packageType);
    }

    /**
     * <p>
     * The type of package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageType} will
     * return {@link PackageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageTypeAsString}.
     * </p>
     * 
     * @return The type of package.
     * @see PackageType
     */
    public final String packageTypeAsString() {
        return packageType;
    }

    /**
     * <p>
     * Description of the package.
     * </p>
     * 
     * @return Description of the package.
     */
    public final String packageDescription() {
        return packageDescription;
    }

    /**
     * <p>
     * The Amazon S3 location from which to import the package.
     * </p>
     * 
     * @return The Amazon S3 location from which to import the package.
     */
    public final PackageSource packageSource() {
        return packageSource;
    }

    /**
     * <p>
     * The configuration parameters for the package being created.
     * </p>
     * 
     * @return The configuration parameters for the package being created.
     */
    public final PackageConfiguration packageConfiguration() {
        return packageConfiguration;
    }

    /**
     * <p>
     * The version of the Amazon OpenSearch Service engine for which is compatible with the package. This can only be
     * specified for package type <code>ZIP-PLUGIN</code>
     * </p>
     * 
     * @return The version of the Amazon OpenSearch Service engine for which is compatible with the package. This can
     *         only be specified for package type <code>ZIP-PLUGIN</code>
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The vending options for the package being created. They determine if the package can be vended to other users.
     * </p>
     * 
     * @return The vending options for the package being created. They determine if the package can be vended to other
     *         users.
     */
    public final PackageVendingOptions packageVendingOptions() {
        return packageVendingOptions;
    }

    /**
     * <p>
     * The encryption parameters for the package being created.
     * </p>
     * 
     * @return The encryption parameters for the package being created.
     */
    public final PackageEncryptionOptions packageEncryptionOptions() {
        return packageEncryptionOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(packageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(packageSource());
        hashCode = 31 * hashCode + Objects.hashCode(packageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(packageVendingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(packageEncryptionOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePackageRequest)) {
            return false;
        }
        CreatePackageRequest other = (CreatePackageRequest) obj;
        return Objects.equals(packageName(), other.packageName())
                && Objects.equals(packageTypeAsString(), other.packageTypeAsString())
                && Objects.equals(packageDescription(), other.packageDescription())
                && Objects.equals(packageSource(), other.packageSource())
                && Objects.equals(packageConfiguration(), other.packageConfiguration())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(packageVendingOptions(), other.packageVendingOptions())
                && Objects.equals(packageEncryptionOptions(), other.packageEncryptionOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePackageRequest").add("PackageName", packageName())
                .add("PackageType", packageTypeAsString()).add("PackageDescription", packageDescription())
                .add("PackageSource", packageSource()).add("PackageConfiguration", packageConfiguration())
                .add("EngineVersion", engineVersion()).add("PackageVendingOptions", packageVendingOptions())
                .add("PackageEncryptionOptions", packageEncryptionOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "PackageType":
            return Optional.ofNullable(clazz.cast(packageTypeAsString()));
        case "PackageDescription":
            return Optional.ofNullable(clazz.cast(packageDescription()));
        case "PackageSource":
            return Optional.ofNullable(clazz.cast(packageSource()));
        case "PackageConfiguration":
            return Optional.ofNullable(clazz.cast(packageConfiguration()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "PackageVendingOptions":
            return Optional.ofNullable(clazz.cast(packageVendingOptions()));
        case "PackageEncryptionOptions":
            return Optional.ofNullable(clazz.cast(packageEncryptionOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PackageName", PACKAGE_NAME_FIELD);
        map.put("PackageType", PACKAGE_TYPE_FIELD);
        map.put("PackageDescription", PACKAGE_DESCRIPTION_FIELD);
        map.put("PackageSource", PACKAGE_SOURCE_FIELD);
        map.put("PackageConfiguration", PACKAGE_CONFIGURATION_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("PackageVendingOptions", PACKAGE_VENDING_OPTIONS_FIELD);
        map.put("PackageEncryptionOptions", PACKAGE_ENCRYPTION_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePackageRequest, T> g) {
        return obj -> g.apply((CreatePackageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePackageRequest> {
        /**
         * <p>
         * Unique name for the package.
         * </p>
         * 
         * @param packageName
         *        Unique name for the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * The type of package.
         * </p>
         * 
         * @param packageType
         *        The type of package.
         * @see PackageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageType
         */
        Builder packageType(String packageType);

        /**
         * <p>
         * The type of package.
         * </p>
         * 
         * @param packageType
         *        The type of package.
         * @see PackageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageType
         */
        Builder packageType(PackageType packageType);

        /**
         * <p>
         * Description of the package.
         * </p>
         * 
         * @param packageDescription
         *        Description of the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageDescription(String packageDescription);

        /**
         * <p>
         * The Amazon S3 location from which to import the package.
         * </p>
         * 
         * @param packageSource
         *        The Amazon S3 location from which to import the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageSource(PackageSource packageSource);

        /**
         * <p>
         * The Amazon S3 location from which to import the package.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageSource.Builder} avoiding the need
         * to create one manually via {@link PackageSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageSource.Builder#build()} is called immediately and its
         * result is passed to {@link #packageSource(PackageSource)}.
         * 
         * @param packageSource
         *        a consumer that will call methods on {@link PackageSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageSource(PackageSource)
         */
        default Builder packageSource(Consumer<PackageSource.Builder> packageSource) {
            return packageSource(PackageSource.builder().applyMutation(packageSource).build());
        }

        /**
         * <p>
         * The configuration parameters for the package being created.
         * </p>
         * 
         * @param packageConfiguration
         *        The configuration parameters for the package being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageConfiguration(PackageConfiguration packageConfiguration);

        /**
         * <p>
         * The configuration parameters for the package being created.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageConfiguration.Builder} avoiding
         * the need to create one manually via {@link PackageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #packageConfiguration(PackageConfiguration)}.
         * 
         * @param packageConfiguration
         *        a consumer that will call methods on {@link PackageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageConfiguration(PackageConfiguration)
         */
        default Builder packageConfiguration(Consumer<PackageConfiguration.Builder> packageConfiguration) {
            return packageConfiguration(PackageConfiguration.builder().applyMutation(packageConfiguration).build());
        }

        /**
         * <p>
         * The version of the Amazon OpenSearch Service engine for which is compatible with the package. This can only
         * be specified for package type <code>ZIP-PLUGIN</code>
         * </p>
         * 
         * @param engineVersion
         *        The version of the Amazon OpenSearch Service engine for which is compatible with the package. This can
         *        only be specified for package type <code>ZIP-PLUGIN</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The vending options for the package being created. They determine if the package can be vended to other
         * users.
         * </p>
         * 
         * @param packageVendingOptions
         *        The vending options for the package being created. They determine if the package can be vended to
         *        other users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVendingOptions(PackageVendingOptions packageVendingOptions);

        /**
         * <p>
         * The vending options for the package being created. They determine if the package can be vended to other
         * users.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageVendingOptions.Builder} avoiding
         * the need to create one manually via {@link PackageVendingOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageVendingOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #packageVendingOptions(PackageVendingOptions)}.
         * 
         * @param packageVendingOptions
         *        a consumer that will call methods on {@link PackageVendingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageVendingOptions(PackageVendingOptions)
         */
        default Builder packageVendingOptions(Consumer<PackageVendingOptions.Builder> packageVendingOptions) {
            return packageVendingOptions(PackageVendingOptions.builder().applyMutation(packageVendingOptions).build());
        }

        /**
         * <p>
         * The encryption parameters for the package being created.
         * </p>
         * 
         * @param packageEncryptionOptions
         *        The encryption parameters for the package being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageEncryptionOptions(PackageEncryptionOptions packageEncryptionOptions);

        /**
         * <p>
         * The encryption parameters for the package being created.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageEncryptionOptions.Builder}
         * avoiding the need to create one manually via {@link PackageEncryptionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageEncryptionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #packageEncryptionOptions(PackageEncryptionOptions)}.
         * 
         * @param packageEncryptionOptions
         *        a consumer that will call methods on {@link PackageEncryptionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageEncryptionOptions(PackageEncryptionOptions)
         */
        default Builder packageEncryptionOptions(Consumer<PackageEncryptionOptions.Builder> packageEncryptionOptions) {
            return packageEncryptionOptions(PackageEncryptionOptions.builder().applyMutation(packageEncryptionOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private String packageName;

        private String packageType;

        private String packageDescription;

        private PackageSource packageSource;

        private PackageConfiguration packageConfiguration;

        private String engineVersion;

        private PackageVendingOptions packageVendingOptions;

        private PackageEncryptionOptions packageEncryptionOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePackageRequest model) {
            super(model);
            packageName(model.packageName);
            packageType(model.packageType);
            packageDescription(model.packageDescription);
            packageSource(model.packageSource);
            packageConfiguration(model.packageConfiguration);
            engineVersion(model.engineVersion);
            packageVendingOptions(model.packageVendingOptions);
            packageEncryptionOptions(model.packageEncryptionOptions);
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageType() {
            return packageType;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final String getPackageDescription() {
            return packageDescription;
        }

        public final void setPackageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
        }

        @Override
        public final Builder packageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
            return this;
        }

        public final PackageSource.Builder getPackageSource() {
            return packageSource != null ? packageSource.toBuilder() : null;
        }

        public final void setPackageSource(PackageSource.BuilderImpl packageSource) {
            this.packageSource = packageSource != null ? packageSource.build() : null;
        }

        @Override
        public final Builder packageSource(PackageSource packageSource) {
            this.packageSource = packageSource;
            return this;
        }

        public final PackageConfiguration.Builder getPackageConfiguration() {
            return packageConfiguration != null ? packageConfiguration.toBuilder() : null;
        }

        public final void setPackageConfiguration(PackageConfiguration.BuilderImpl packageConfiguration) {
            this.packageConfiguration = packageConfiguration != null ? packageConfiguration.build() : null;
        }

        @Override
        public final Builder packageConfiguration(PackageConfiguration packageConfiguration) {
            this.packageConfiguration = packageConfiguration;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final PackageVendingOptions.Builder getPackageVendingOptions() {
            return packageVendingOptions != null ? packageVendingOptions.toBuilder() : null;
        }

        public final void setPackageVendingOptions(PackageVendingOptions.BuilderImpl packageVendingOptions) {
            this.packageVendingOptions = packageVendingOptions != null ? packageVendingOptions.build() : null;
        }

        @Override
        public final Builder packageVendingOptions(PackageVendingOptions packageVendingOptions) {
            this.packageVendingOptions = packageVendingOptions;
            return this;
        }

        public final PackageEncryptionOptions.Builder getPackageEncryptionOptions() {
            return packageEncryptionOptions != null ? packageEncryptionOptions.toBuilder() : null;
        }

        public final void setPackageEncryptionOptions(PackageEncryptionOptions.BuilderImpl packageEncryptionOptions) {
            this.packageEncryptionOptions = packageEncryptionOptions != null ? packageEncryptionOptions.build() : null;
        }

        @Override
        public final Builder packageEncryptionOptions(PackageEncryptionOptions packageEncryptionOptions) {
            this.packageEncryptionOptions = packageEncryptionOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePackageRequest build() {
            return new CreatePackageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
