/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatePackagesRequest extends OpenSearchRequest implements
        ToCopyableBuilder<AssociatePackagesRequest.Builder, AssociatePackagesRequest> {
    private static final SdkField<List<PackageDetailsForAssociation>> PACKAGE_LIST_FIELD = SdkField
            .<List<PackageDetailsForAssociation>> builder(MarshallingType.LIST)
            .memberName("PackageList")
            .getter(getter(AssociatePackagesRequest::packageList))
            .setter(setter(Builder::packageList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PackageDetailsForAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(PackageDetailsForAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(AssociatePackagesRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_LIST_FIELD,
            DOMAIN_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<PackageDetailsForAssociation> packageList;

    private final String domainName;

    private AssociatePackagesRequest(BuilderImpl builder) {
        super(builder);
        this.packageList = builder.packageList;
        this.domainName = builder.domainName;
    }

    /**
     * For responses, this returns true if the service returned a value for the PackageList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPackageList() {
        return packageList != null && !(packageList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of packages and their prerequisites to be associated with a domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPackageList} method.
     * </p>
     * 
     * @return A list of packages and their prerequisites to be associated with a domain.
     */
    public final List<PackageDetailsForAssociation> packageList() {
        return packageList;
    }

    /**
     * Returns the value of the DomainName property for this object.
     * 
     * @return The value of the DomainName property for this object.
     */
    public final String domainName() {
        return domainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPackageList() ? packageList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatePackagesRequest)) {
            return false;
        }
        AssociatePackagesRequest other = (AssociatePackagesRequest) obj;
        return hasPackageList() == other.hasPackageList() && Objects.equals(packageList(), other.packageList())
                && Objects.equals(domainName(), other.domainName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociatePackagesRequest").add("PackageList", hasPackageList() ? packageList() : null)
                .add("DomainName", domainName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageList":
            return Optional.ofNullable(clazz.cast(packageList()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PackageList", PACKAGE_LIST_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociatePackagesRequest, T> g) {
        return obj -> g.apply((AssociatePackagesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociatePackagesRequest> {
        /**
         * <p>
         * A list of packages and their prerequisites to be associated with a domain.
         * </p>
         * 
         * @param packageList
         *        A list of packages and their prerequisites to be associated with a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageList(Collection<PackageDetailsForAssociation> packageList);

        /**
         * <p>
         * A list of packages and their prerequisites to be associated with a domain.
         * </p>
         * 
         * @param packageList
         *        A list of packages and their prerequisites to be associated with a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageList(PackageDetailsForAssociation... packageList);

        /**
         * <p>
         * A list of packages and their prerequisites to be associated with a domain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.PackageDetailsForAssociation.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.opensearch.model.PackageDetailsForAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.PackageDetailsForAssociation.Builder#build()} is
         * called immediately and its result is passed to {@link #packageList(List<PackageDetailsForAssociation>)}.
         * 
         * @param packageList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.PackageDetailsForAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageList(java.util.Collection<PackageDetailsForAssociation>)
         */
        Builder packageList(Consumer<PackageDetailsForAssociation.Builder>... packageList);

        /**
         * Sets the value of the DomainName property for this object.
         *
         * @param domainName
         *        The new value for the DomainName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private List<PackageDetailsForAssociation> packageList = DefaultSdkAutoConstructList.getInstance();

        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatePackagesRequest model) {
            super(model);
            packageList(model.packageList);
            domainName(model.domainName);
        }

        public final List<PackageDetailsForAssociation.Builder> getPackageList() {
            List<PackageDetailsForAssociation.Builder> result = PackageDetailsForAssociationListCopier
                    .copyToBuilder(this.packageList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPackageList(Collection<PackageDetailsForAssociation.BuilderImpl> packageList) {
            this.packageList = PackageDetailsForAssociationListCopier.copyFromBuilder(packageList);
        }

        @Override
        public final Builder packageList(Collection<PackageDetailsForAssociation> packageList) {
            this.packageList = PackageDetailsForAssociationListCopier.copy(packageList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageList(PackageDetailsForAssociation... packageList) {
            packageList(Arrays.asList(packageList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageList(Consumer<PackageDetailsForAssociation.Builder>... packageList) {
            packageList(Stream.of(packageList).map(c -> PackageDetailsForAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociatePackagesRequest build() {
            return new AssociatePackagesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
