/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters to the <code>AddDataSource</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddDataSourceRequest extends OpenSearchRequest implements
        ToCopyableBuilder<AddDataSourceRequest.Builder, AddDataSourceRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(AddDataSourceRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AddDataSourceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<DataSourceType> DATA_SOURCE_TYPE_FIELD = SdkField
            .<DataSourceType> builder(MarshallingType.SDK_POJO).memberName("DataSourceType")
            .getter(getter(AddDataSourceRequest::dataSourceType)).setter(setter(Builder::dataSourceType))
            .constructor(DataSourceType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AddDataSourceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, NAME_FIELD,
            DATA_SOURCE_TYPE_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String name;

    private final DataSourceType dataSourceType;

    private final String description;

    private AddDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.name = builder.name;
        this.dataSourceType = builder.dataSourceType;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name of the domain to add the data source to.
     * </p>
     * 
     * @return The name of the domain to add the data source to.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A name for the data source.
     * </p>
     * 
     * @return A name for the data source.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of data source.
     * </p>
     * 
     * @return The type of data source.
     */
    public final DataSourceType dataSourceType() {
        return dataSourceType;
    }

    /**
     * <p>
     * A description of the data source.
     * </p>
     * 
     * @return A description of the data source.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceType());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddDataSourceRequest)) {
            return false;
        }
        AddDataSourceRequest other = (AddDataSourceRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(name(), other.name())
                && Objects.equals(dataSourceType(), other.dataSourceType()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddDataSourceRequest").add("DomainName", domainName()).add("Name", name())
                .add("DataSourceType", dataSourceType()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DataSourceType":
            return Optional.ofNullable(clazz.cast(dataSourceType()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("DataSourceType", DATA_SOURCE_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddDataSourceRequest, T> g) {
        return obj -> g.apply((AddDataSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddDataSourceRequest> {
        /**
         * <p>
         * The name of the domain to add the data source to.
         * </p>
         * 
         * @param domainName
         *        The name of the domain to add the data source to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A name for the data source.
         * </p>
         * 
         * @param name
         *        A name for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of data source.
         * </p>
         * 
         * @param dataSourceType
         *        The type of data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceType(DataSourceType dataSourceType);

        /**
         * <p>
         * The type of data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceType.Builder} avoiding the need
         * to create one manually via {@link DataSourceType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceType.Builder#build()} is called immediately and its
         * result is passed to {@link #dataSourceType(DataSourceType)}.
         * 
         * @param dataSourceType
         *        a consumer that will call methods on {@link DataSourceType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSourceType(DataSourceType)
         */
        default Builder dataSourceType(Consumer<DataSourceType.Builder> dataSourceType) {
            return dataSourceType(DataSourceType.builder().applyMutation(dataSourceType).build());
        }

        /**
         * <p>
         * A description of the data source.
         * </p>
         * 
         * @param description
         *        A description of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private String domainName;

        private String name;

        private DataSourceType dataSourceType;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(AddDataSourceRequest model) {
            super(model);
            domainName(model.domainName);
            name(model.name);
            dataSourceType(model.dataSourceType);
            description(model.description);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DataSourceType.Builder getDataSourceType() {
            return dataSourceType != null ? dataSourceType.toBuilder() : null;
        }

        public final void setDataSourceType(DataSourceType.BuilderImpl dataSourceType) {
            this.dataSourceType = dataSourceType != null ? dataSourceType.build() : null;
        }

        @Override
        public final Builder dataSourceType(DataSourceType dataSourceType) {
            this.dataSourceType = dataSourceType;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddDataSourceRequest build() {
            return new AddDataSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
