/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchClient;
import software.amazon.awssdk.services.opensearch.model.ListVersionsRequest;
import software.amazon.awssdk.services.opensearch.model.ListVersionsResponse;

public class ListVersionsIterable
implements SdkIterable<ListVersionsResponse> {
    private final OpenSearchClient client;
    private final ListVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVersionsIterable(OpenSearchClient client, ListVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListVersionsResponseFetcher();
    }

    public Iterator<ListVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListVersionsResponseFetcher
    implements SyncPageFetcher<ListVersionsResponse> {
        private ListVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVersionsResponse nextPage(ListVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListVersionsIterable.this.client.listVersions(ListVersionsIterable.this.firstRequest);
            }
            return ListVersionsIterable.this.client.listVersions((ListVersionsRequest)((Object)ListVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

