/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchAsyncClient;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse;

public class DescribeDomainAutoTunesPublisher
implements SdkPublisher<DescribeDomainAutoTunesResponse> {
    private final OpenSearchAsyncClient client;
    private final DescribeDomainAutoTunesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDomainAutoTunesPublisher(OpenSearchAsyncClient client, DescribeDomainAutoTunesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDomainAutoTunesPublisher(OpenSearchAsyncClient client, DescribeDomainAutoTunesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDomainAutoTunesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDomainAutoTunesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeDomainAutoTunesResponseFetcher
    implements AsyncPageFetcher<DescribeDomainAutoTunesResponse> {
        private DescribeDomainAutoTunesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDomainAutoTunesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeDomainAutoTunesResponse> nextPage(DescribeDomainAutoTunesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDomainAutoTunesPublisher.this.client.describeDomainAutoTunes(DescribeDomainAutoTunesPublisher.this.firstRequest);
            }
            return DescribeDomainAutoTunesPublisher.this.client.describeDomainAutoTunes((DescribeDomainAutoTunesRequest)((Object)DescribeDomainAutoTunesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

