/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.nimble.NimbleAsyncClient;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileRequest;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileResponse;
import software.amazon.awssdk.services.nimble.model.GetStreamingImageRequest;
import software.amazon.awssdk.services.nimble.model.GetStreamingImageResponse;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionRequest;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionResponse;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamRequest;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamResponse;
import software.amazon.awssdk.services.nimble.model.GetStudioComponentRequest;
import software.amazon.awssdk.services.nimble.model.GetStudioComponentResponse;
import software.amazon.awssdk.services.nimble.model.GetStudioRequest;
import software.amazon.awssdk.services.nimble.model.GetStudioResponse;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.services.nimble.waiters.NimbleAsyncWaiter;
import software.amazon.awssdk.services.nimble.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultNimbleAsyncWaiter
implements NimbleAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final NimbleAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetLaunchProfileResponse> launchProfileDeletedWaiter;
    private final AsyncWaiter<GetLaunchProfileResponse> launchProfileReadyWaiter;
    private final AsyncWaiter<GetStreamingImageResponse> streamingImageDeletedWaiter;
    private final AsyncWaiter<GetStreamingImageResponse> streamingImageReadyWaiter;
    private final AsyncWaiter<GetStreamingSessionResponse> streamingSessionDeletedWaiter;
    private final AsyncWaiter<GetStreamingSessionResponse> streamingSessionReadyWaiter;
    private final AsyncWaiter<GetStreamingSessionResponse> streamingSessionStoppedWaiter;
    private final AsyncWaiter<GetStreamingSessionStreamResponse> streamingSessionStreamReadyWaiter;
    private final AsyncWaiter<GetStudioComponentResponse> studioComponentDeletedWaiter;
    private final AsyncWaiter<GetStudioComponentResponse> studioComponentReadyWaiter;
    private final AsyncWaiter<GetStudioResponse> studioDeletedWaiter;
    private final AsyncWaiter<GetStudioResponse> studioReadyWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultNimbleAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (NimbleAsyncClient)NimbleAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.launchProfileDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetLaunchProfileResponse.class).acceptors(DefaultNimbleAsyncWaiter.launchProfileDeletedWaiterAcceptors())).overrideConfiguration(DefaultNimbleAsyncWaiter.launchProfileDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.launchProfileReadyWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetLaunchProfileResponse.class).acceptors(DefaultNimbleAsyncWaiter.launchProfileReadyWaiterAcceptors())).overrideConfiguration(DefaultNimbleAsyncWaiter.launchProfileReadyWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.streamingImageDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetStreamingImageResponse.class).acceptors(DefaultNimbleAsyncWaiter.streamingImageDeletedWaiterAcceptors())).overrideConfiguration(DefaultNimbleAsyncWaiter.streamingImageDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.streamingImageReadyWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetStreamingImageResponse.class).acceptors(DefaultNimbleAsyncWaiter.streamingImageReadyWaiterAcceptors())).overrideConfiguration(DefaultNimbleAsyncWaiter.streamingImageReadyWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.streamingSessionDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetStreamingSessionResponse.class).acceptors(DefaultNimbleAsyncWaiter.streamingSessionDeletedWaiterAcceptors())).overrideConfiguration(DefaultNimbleAsyncWaiter.streamingSessionDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.streamingSessionReadyWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetStreamingSessionResponse.class).acceptors(DefaultNimbleAsyncWaiter.streamingSessionReadyWaiterAcceptors())).overrideConfiguration(DefaultNimbleAsyncWaiter.streamingSessionReadyWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.streamingSessionStoppedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetStreamingSessionResponse.class).acceptors(DefaultNimbleAsyncWaiter.streamingSessionStoppedWaiterAcceptors())).overrideConfiguration(DefaultNimbleAsyncWaiter.streamingSessionStoppedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.streamingSessionStreamReadyWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetStreamingSessionStreamResponse.class).acceptors(DefaultNimbleAsyncWaiter.streamingSessionStreamReadyWaiterAcceptors())).overrideConfiguration(DefaultNimbleAsyncWaiter.streamingSessionStreamReadyWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.studioComponentDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetStudioComponentResponse.class).acceptors(DefaultNimbleAsyncWaiter.studioComponentDeletedWaiterAcceptors())).overrideConfiguration(DefaultNimbleAsyncWaiter.studioComponentDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.studioComponentReadyWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetStudioComponentResponse.class).acceptors(DefaultNimbleAsyncWaiter.studioComponentReadyWaiterAcceptors())).overrideConfiguration(DefaultNimbleAsyncWaiter.studioComponentReadyWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.studioDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetStudioResponse.class).acceptors(DefaultNimbleAsyncWaiter.studioDeletedWaiterAcceptors())).overrideConfiguration(DefaultNimbleAsyncWaiter.studioDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.studioReadyWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetStudioResponse.class).acceptors(DefaultNimbleAsyncWaiter.studioReadyWaiterAcceptors())).overrideConfiguration(DefaultNimbleAsyncWaiter.studioReadyWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetLaunchProfileResponse>> waitUntilLaunchProfileDeleted(GetLaunchProfileRequest getLaunchProfileRequest) {
        return this.launchProfileDeletedWaiter.runAsync(() -> this.client.getLaunchProfile(this.applyWaitersUserAgent(getLaunchProfileRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetLaunchProfileResponse>> waitUntilLaunchProfileDeleted(GetLaunchProfileRequest getLaunchProfileRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.launchProfileDeletedWaiter.runAsync(() -> this.client.getLaunchProfile(this.applyWaitersUserAgent(getLaunchProfileRequest)), DefaultNimbleAsyncWaiter.launchProfileDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetLaunchProfileResponse>> waitUntilLaunchProfileReady(GetLaunchProfileRequest getLaunchProfileRequest) {
        return this.launchProfileReadyWaiter.runAsync(() -> this.client.getLaunchProfile(this.applyWaitersUserAgent(getLaunchProfileRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetLaunchProfileResponse>> waitUntilLaunchProfileReady(GetLaunchProfileRequest getLaunchProfileRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.launchProfileReadyWaiter.runAsync(() -> this.client.getLaunchProfile(this.applyWaitersUserAgent(getLaunchProfileRequest)), DefaultNimbleAsyncWaiter.launchProfileReadyWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamingImageResponse>> waitUntilStreamingImageDeleted(GetStreamingImageRequest getStreamingImageRequest) {
        return this.streamingImageDeletedWaiter.runAsync(() -> this.client.getStreamingImage(this.applyWaitersUserAgent(getStreamingImageRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamingImageResponse>> waitUntilStreamingImageDeleted(GetStreamingImageRequest getStreamingImageRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamingImageDeletedWaiter.runAsync(() -> this.client.getStreamingImage(this.applyWaitersUserAgent(getStreamingImageRequest)), DefaultNimbleAsyncWaiter.streamingImageDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamingImageResponse>> waitUntilStreamingImageReady(GetStreamingImageRequest getStreamingImageRequest) {
        return this.streamingImageReadyWaiter.runAsync(() -> this.client.getStreamingImage(this.applyWaitersUserAgent(getStreamingImageRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamingImageResponse>> waitUntilStreamingImageReady(GetStreamingImageRequest getStreamingImageRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamingImageReadyWaiter.runAsync(() -> this.client.getStreamingImage(this.applyWaitersUserAgent(getStreamingImageRequest)), DefaultNimbleAsyncWaiter.streamingImageReadyWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamingSessionResponse>> waitUntilStreamingSessionDeleted(GetStreamingSessionRequest getStreamingSessionRequest) {
        return this.streamingSessionDeletedWaiter.runAsync(() -> this.client.getStreamingSession(this.applyWaitersUserAgent(getStreamingSessionRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamingSessionResponse>> waitUntilStreamingSessionDeleted(GetStreamingSessionRequest getStreamingSessionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamingSessionDeletedWaiter.runAsync(() -> this.client.getStreamingSession(this.applyWaitersUserAgent(getStreamingSessionRequest)), DefaultNimbleAsyncWaiter.streamingSessionDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamingSessionResponse>> waitUntilStreamingSessionReady(GetStreamingSessionRequest getStreamingSessionRequest) {
        return this.streamingSessionReadyWaiter.runAsync(() -> this.client.getStreamingSession(this.applyWaitersUserAgent(getStreamingSessionRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamingSessionResponse>> waitUntilStreamingSessionReady(GetStreamingSessionRequest getStreamingSessionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamingSessionReadyWaiter.runAsync(() -> this.client.getStreamingSession(this.applyWaitersUserAgent(getStreamingSessionRequest)), DefaultNimbleAsyncWaiter.streamingSessionReadyWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamingSessionResponse>> waitUntilStreamingSessionStopped(GetStreamingSessionRequest getStreamingSessionRequest) {
        return this.streamingSessionStoppedWaiter.runAsync(() -> this.client.getStreamingSession(this.applyWaitersUserAgent(getStreamingSessionRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamingSessionResponse>> waitUntilStreamingSessionStopped(GetStreamingSessionRequest getStreamingSessionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamingSessionStoppedWaiter.runAsync(() -> this.client.getStreamingSession(this.applyWaitersUserAgent(getStreamingSessionRequest)), DefaultNimbleAsyncWaiter.streamingSessionStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamingSessionStreamResponse>> waitUntilStreamingSessionStreamReady(GetStreamingSessionStreamRequest getStreamingSessionStreamRequest) {
        return this.streamingSessionStreamReadyWaiter.runAsync(() -> this.client.getStreamingSessionStream(this.applyWaitersUserAgent(getStreamingSessionStreamRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamingSessionStreamResponse>> waitUntilStreamingSessionStreamReady(GetStreamingSessionStreamRequest getStreamingSessionStreamRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamingSessionStreamReadyWaiter.runAsync(() -> this.client.getStreamingSessionStream(this.applyWaitersUserAgent(getStreamingSessionStreamRequest)), DefaultNimbleAsyncWaiter.streamingSessionStreamReadyWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStudioComponentResponse>> waitUntilStudioComponentDeleted(GetStudioComponentRequest getStudioComponentRequest) {
        return this.studioComponentDeletedWaiter.runAsync(() -> this.client.getStudioComponent(this.applyWaitersUserAgent(getStudioComponentRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStudioComponentResponse>> waitUntilStudioComponentDeleted(GetStudioComponentRequest getStudioComponentRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.studioComponentDeletedWaiter.runAsync(() -> this.client.getStudioComponent(this.applyWaitersUserAgent(getStudioComponentRequest)), DefaultNimbleAsyncWaiter.studioComponentDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStudioComponentResponse>> waitUntilStudioComponentReady(GetStudioComponentRequest getStudioComponentRequest) {
        return this.studioComponentReadyWaiter.runAsync(() -> this.client.getStudioComponent(this.applyWaitersUserAgent(getStudioComponentRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStudioComponentResponse>> waitUntilStudioComponentReady(GetStudioComponentRequest getStudioComponentRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.studioComponentReadyWaiter.runAsync(() -> this.client.getStudioComponent(this.applyWaitersUserAgent(getStudioComponentRequest)), DefaultNimbleAsyncWaiter.studioComponentReadyWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStudioResponse>> waitUntilStudioDeleted(GetStudioRequest getStudioRequest) {
        return this.studioDeletedWaiter.runAsync(() -> this.client.getStudio(this.applyWaitersUserAgent(getStudioRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStudioResponse>> waitUntilStudioDeleted(GetStudioRequest getStudioRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.studioDeletedWaiter.runAsync(() -> this.client.getStudio(this.applyWaitersUserAgent(getStudioRequest)), DefaultNimbleAsyncWaiter.studioDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStudioResponse>> waitUntilStudioReady(GetStudioRequest getStudioRequest) {
        return this.studioReadyWaiter.runAsync(() -> this.client.getStudio(this.applyWaitersUserAgent(getStudioRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStudioResponse>> waitUntilStudioReady(GetStudioRequest getStudioRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.studioReadyWaiter.runAsync(() -> this.client.getStudio(this.applyWaitersUserAgent(getStudioRequest)), DefaultNimbleAsyncWaiter.studioReadyWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetLaunchProfileResponse>> launchProfileDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetLaunchProfileResponse>> result = new ArrayList<WaiterAcceptor<? super GetLaunchProfileResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("launchProfile").field("state").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("launchProfile").field("state").value(), "DELETE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetLaunchProfileResponse>> launchProfileReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetLaunchProfileResponse>> result = new ArrayList<WaiterAcceptor<? super GetLaunchProfileResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("launchProfile").field("state").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("launchProfile").field("state").value(), "CREATE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("launchProfile").field("state").value(), "UPDATE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamingImageResponse>> streamingImageDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamingImageResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamingImageResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("streamingImage").field("state").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("streamingImage").field("state").value(), "DELETE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamingImageResponse>> streamingImageReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamingImageResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamingImageResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("streamingImage").field("state").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("streamingImage").field("state").value(), "CREATE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("streamingImage").field("state").value(), "UPDATE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamingSessionResponse>> streamingSessionDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamingSessionResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamingSessionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("session").field("state").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("session").field("state").value(), "DELETE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamingSessionResponse>> streamingSessionReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamingSessionResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamingSessionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("session").field("state").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("session").field("state").value(), "CREATE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("session").field("state").value(), "START_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamingSessionResponse>> streamingSessionStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamingSessionResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamingSessionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("session").field("state").value(), "STOPPED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("session").field("state").value(), "STOP_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamingSessionStreamResponse>> streamingSessionStreamReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamingSessionStreamResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamingSessionStreamResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("stream").field("state").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("stream").field("state").value(), "CREATE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStudioComponentResponse>> studioComponentDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStudioComponentResponse>> result = new ArrayList<WaiterAcceptor<? super GetStudioComponentResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("studioComponent").field("state").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("studioComponent").field("state").value(), "DELETE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStudioComponentResponse>> studioComponentReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStudioComponentResponse>> result = new ArrayList<WaiterAcceptor<? super GetStudioComponentResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("studioComponent").field("state").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("studioComponent").field("state").value(), "CREATE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("studioComponent").field("state").value(), "UPDATE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStudioResponse>> studioDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStudioResponse>> result = new ArrayList<WaiterAcceptor<? super GetStudioResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("studio").field("state").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("studio").field("state").value(), "DELETE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStudioResponse>> studioReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStudioResponse>> result = new ArrayList<WaiterAcceptor<? super GetStudioResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("studio").field("state").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("studio").field("state").value(), "CREATE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("studio").field("state").value(), "UPDATE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration launchProfileDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(150);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration launchProfileReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(150);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamingImageDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamingImageReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamingSessionDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamingSessionReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamingSessionStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamingSessionStreamReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(30);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration studioComponentDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration studioComponentReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration studioDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration studioReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static NimbleAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends NimbleRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((NimbleRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements NimbleAsyncWaiter.Builder {
        private NimbleAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public NimbleAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public NimbleAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public NimbleAsyncWaiter.Builder client(NimbleAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public NimbleAsyncWaiter build() {
            return new DefaultNimbleAsyncWaiter(this);
        }
    }
}

