/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.StreamingSessionStorageMode;
import software.amazon.awssdk.services.nimble.model.StreamingSessionStorageModeListCopier;
import software.amazon.awssdk.services.nimble.model.StreamingSessionStorageRoot;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamConfigurationSessionStorage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamConfigurationSessionStorage> {
    private static final SdkField<List<String>> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mode").getter(StreamConfigurationSessionStorage.getter(StreamConfigurationSessionStorage::modeAsStrings)).setter(StreamConfigurationSessionStorage.setter(Builder::modeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StreamingSessionStorageRoot> ROOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("root").getter(StreamConfigurationSessionStorage.getter(StreamConfigurationSessionStorage::root)).setter(StreamConfigurationSessionStorage.setter(Builder::root)).constructor(StreamingSessionStorageRoot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("root").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, ROOT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> mode;
    private final StreamingSessionStorageRoot root;

    private StreamConfigurationSessionStorage(BuilderImpl builder) {
        this.mode = builder.mode;
        this.root = builder.root;
    }

    public final List<StreamingSessionStorageMode> mode() {
        return StreamingSessionStorageModeListCopier.copyStringToEnum(this.mode);
    }

    public final boolean hasMode() {
        return this.mode != null && !(this.mode instanceof SdkAutoConstructList);
    }

    public final List<String> modeAsStrings() {
        return this.mode;
    }

    public final StreamingSessionStorageRoot root() {
        return this.root;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMode() ? this.modeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.root());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamConfigurationSessionStorage)) {
            return false;
        }
        StreamConfigurationSessionStorage other = (StreamConfigurationSessionStorage)obj;
        return this.hasMode() == other.hasMode() && Objects.equals(this.modeAsStrings(), other.modeAsStrings()) && Objects.equals(this.root(), other.root());
    }

    public final String toString() {
        return ToString.builder((String)"StreamConfigurationSessionStorage").add("Mode", this.hasMode() ? this.modeAsStrings() : null).add("Root", (Object)this.root()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsStrings()));
            }
            case "root": {
                return Optional.ofNullable(clazz.cast(this.root()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamConfigurationSessionStorage, T> g) {
        return obj -> g.apply((StreamConfigurationSessionStorage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> mode = DefaultSdkAutoConstructList.getInstance();
        private StreamingSessionStorageRoot root;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamConfigurationSessionStorage model) {
            this.modeWithStrings(model.mode);
            this.root(model.root);
        }

        public final Collection<String> getMode() {
            if (this.mode instanceof SdkAutoConstructList) {
                return null;
            }
            return this.mode;
        }

        public final void setMode(Collection<String> mode) {
            this.mode = StreamingSessionStorageModeListCopier.copy(mode);
        }

        @Override
        public final Builder modeWithStrings(Collection<String> mode) {
            this.mode = StreamingSessionStorageModeListCopier.copy(mode);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modeWithStrings(String ... mode) {
            this.modeWithStrings(Arrays.asList(mode));
            return this;
        }

        @Override
        public final Builder mode(Collection<StreamingSessionStorageMode> mode) {
            this.mode = StreamingSessionStorageModeListCopier.copyEnumToString(mode);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mode(StreamingSessionStorageMode ... mode) {
            this.mode(Arrays.asList(mode));
            return this;
        }

        public final StreamingSessionStorageRoot.Builder getRoot() {
            return this.root != null ? this.root.toBuilder() : null;
        }

        public final void setRoot(StreamingSessionStorageRoot.BuilderImpl root) {
            this.root = root != null ? root.build() : null;
        }

        @Override
        public final Builder root(StreamingSessionStorageRoot root) {
            this.root = root;
            return this;
        }

        public StreamConfigurationSessionStorage build() {
            return new StreamConfigurationSessionStorage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamConfigurationSessionStorage> {
        public Builder modeWithStrings(Collection<String> var1);

        public Builder modeWithStrings(String ... var1);

        public Builder mode(Collection<StreamingSessionStorageMode> var1);

        public Builder mode(StreamingSessionStorageMode ... var1);

        public Builder root(StreamingSessionStorageRoot var1);

        default public Builder root(Consumer<StreamingSessionStorageRoot.Builder> root) {
            return this.root((StreamingSessionStorageRoot)((StreamingSessionStorageRoot.Builder)StreamingSessionStorageRoot.builder().applyMutation(root)).build());
        }
    }
}

