/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.nimble.model.StudioPersona;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NewStudioMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NewStudioMember> {
    private static final SdkField<String> PERSONA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("persona").getter(NewStudioMember.getter(NewStudioMember::personaAsString)).setter(NewStudioMember.setter(Builder::persona)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("persona").build()}).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalId").getter(NewStudioMember.getter(NewStudioMember::principalId)).setter(NewStudioMember.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERSONA_FIELD, PRINCIPAL_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String persona;
    private final String principalId;

    private NewStudioMember(BuilderImpl builder) {
        this.persona = builder.persona;
        this.principalId = builder.principalId;
    }

    public final StudioPersona persona() {
        return StudioPersona.fromValue(this.persona);
    }

    public final String personaAsString() {
        return this.persona;
    }

    public final String principalId() {
        return this.principalId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.personaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewStudioMember)) {
            return false;
        }
        NewStudioMember other = (NewStudioMember)obj;
        return Objects.equals(this.personaAsString(), other.personaAsString()) && Objects.equals(this.principalId(), other.principalId());
    }

    public final String toString() {
        return ToString.builder((String)"NewStudioMember").add("Persona", (Object)this.personaAsString()).add("PrincipalId", (Object)this.principalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "persona": {
                return Optional.ofNullable(clazz.cast(this.personaAsString()));
            }
            case "principalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NewStudioMember, T> g) {
        return obj -> g.apply((NewStudioMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String persona;
        private String principalId;

        private BuilderImpl() {
        }

        private BuilderImpl(NewStudioMember model) {
            this.persona(model.persona);
            this.principalId(model.principalId);
        }

        public final String getPersona() {
            return this.persona;
        }

        public final void setPersona(String persona) {
            this.persona = persona;
        }

        @Override
        public final Builder persona(String persona) {
            this.persona = persona;
            return this;
        }

        @Override
        public final Builder persona(StudioPersona persona) {
            this.persona(persona == null ? null : persona.toString());
            return this;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public NewStudioMember build() {
            return new NewStudioMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NewStudioMember> {
        public Builder persona(String var1);

        public Builder persona(StudioPersona var1);

        public Builder principalId(String var1);
    }
}

