/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteStudioComponentResponse extends NimbleResponse implements
        ToCopyableBuilder<DeleteStudioComponentResponse.Builder, DeleteStudioComponentResponse> {
    private static final SdkField<StudioComponent> STUDIO_COMPONENT_FIELD = SdkField
            .<StudioComponent> builder(MarshallingType.SDK_POJO).memberName("studioComponent")
            .getter(getter(DeleteStudioComponentResponse::studioComponent)).setter(setter(Builder::studioComponent))
            .constructor(StudioComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STUDIO_COMPONENT_FIELD));

    private final StudioComponent studioComponent;

    private DeleteStudioComponentResponse(BuilderImpl builder) {
        super(builder);
        this.studioComponent = builder.studioComponent;
    }

    /**
     * <p>
     * Information about the studio component.
     * </p>
     * 
     * @return Information about the studio component.
     */
    public final StudioComponent studioComponent() {
        return studioComponent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(studioComponent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteStudioComponentResponse)) {
            return false;
        }
        DeleteStudioComponentResponse other = (DeleteStudioComponentResponse) obj;
        return Objects.equals(studioComponent(), other.studioComponent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteStudioComponentResponse").add("StudioComponent", studioComponent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "studioComponent":
            return Optional.ofNullable(clazz.cast(studioComponent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteStudioComponentResponse, T> g) {
        return obj -> g.apply((DeleteStudioComponentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteStudioComponentResponse> {
        /**
         * <p>
         * Information about the studio component.
         * </p>
         * 
         * @param studioComponent
         *        Information about the studio component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioComponent(StudioComponent studioComponent);

        /**
         * <p>
         * Information about the studio component.
         * </p>
         * This is a convenience method that creates an instance of the {@link StudioComponent.Builder} avoiding the
         * need to create one manually via {@link StudioComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StudioComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #studioComponent(StudioComponent)}.
         * 
         * @param studioComponent
         *        a consumer that will call methods on {@link StudioComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #studioComponent(StudioComponent)
         */
        default Builder studioComponent(Consumer<StudioComponent.Builder> studioComponent) {
            return studioComponent(StudioComponent.builder().applyMutation(studioComponent).build());
        }
    }

    static final class BuilderImpl extends NimbleResponse.BuilderImpl implements Builder {
        private StudioComponent studioComponent;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteStudioComponentResponse model) {
            super(model);
            studioComponent(model.studioComponent);
        }

        public final StudioComponent.Builder getStudioComponent() {
            return studioComponent != null ? studioComponent.toBuilder() : null;
        }

        public final void setStudioComponent(StudioComponent.BuilderImpl studioComponent) {
            this.studioComponent = studioComponent != null ? studioComponent.build() : null;
        }

        @Override
        public final Builder studioComponent(StudioComponent studioComponent) {
            this.studioComponent = studioComponent;
            return this;
        }

        @Override
        public DeleteStudioComponentResponse build() {
            return new DeleteStudioComponentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
