/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLaunchProfileInitializationResponse extends NimbleResponse implements
        ToCopyableBuilder<GetLaunchProfileInitializationResponse.Builder, GetLaunchProfileInitializationResponse> {
    private static final SdkField<LaunchProfileInitialization> LAUNCH_PROFILE_INITIALIZATION_FIELD = SdkField
            .<LaunchProfileInitialization> builder(MarshallingType.SDK_POJO)
            .memberName("launchProfileInitialization")
            .getter(getter(GetLaunchProfileInitializationResponse::launchProfileInitialization))
            .setter(setter(Builder::launchProfileInitialization))
            .constructor(LaunchProfileInitialization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfileInitialization")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LAUNCH_PROFILE_INITIALIZATION_FIELD));

    private final LaunchProfileInitialization launchProfileInitialization;

    private GetLaunchProfileInitializationResponse(BuilderImpl builder) {
        super(builder);
        this.launchProfileInitialization = builder.launchProfileInitialization;
    }

    /**
     * <p>
     * The launch profile initialization.
     * </p>
     * 
     * @return The launch profile initialization.
     */
    public final LaunchProfileInitialization launchProfileInitialization() {
        return launchProfileInitialization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(launchProfileInitialization());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLaunchProfileInitializationResponse)) {
            return false;
        }
        GetLaunchProfileInitializationResponse other = (GetLaunchProfileInitializationResponse) obj;
        return Objects.equals(launchProfileInitialization(), other.launchProfileInitialization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLaunchProfileInitializationResponse")
                .add("LaunchProfileInitialization", launchProfileInitialization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "launchProfileInitialization":
            return Optional.ofNullable(clazz.cast(launchProfileInitialization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLaunchProfileInitializationResponse, T> g) {
        return obj -> g.apply((GetLaunchProfileInitializationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLaunchProfileInitializationResponse> {
        /**
         * <p>
         * The launch profile initialization.
         * </p>
         * 
         * @param launchProfileInitialization
         *        The launch profile initialization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchProfileInitialization(LaunchProfileInitialization launchProfileInitialization);

        /**
         * <p>
         * The launch profile initialization.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchProfileInitialization.Builder}
         * avoiding the need to create one manually via {@link LaunchProfileInitialization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchProfileInitialization.Builder#build()} is called
         * immediately and its result is passed to {@link #launchProfileInitialization(LaunchProfileInitialization)}.
         * 
         * @param launchProfileInitialization
         *        a consumer that will call methods on {@link LaunchProfileInitialization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchProfileInitialization(LaunchProfileInitialization)
         */
        default Builder launchProfileInitialization(Consumer<LaunchProfileInitialization.Builder> launchProfileInitialization) {
            return launchProfileInitialization(LaunchProfileInitialization.builder().applyMutation(launchProfileInitialization)
                    .build());
        }
    }

    static final class BuilderImpl extends NimbleResponse.BuilderImpl implements Builder {
        private LaunchProfileInitialization launchProfileInitialization;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLaunchProfileInitializationResponse model) {
            super(model);
            launchProfileInitialization(model.launchProfileInitialization);
        }

        public final LaunchProfileInitialization.Builder getLaunchProfileInitialization() {
            return launchProfileInitialization != null ? launchProfileInitialization.toBuilder() : null;
        }

        public final void setLaunchProfileInitialization(LaunchProfileInitialization.BuilderImpl launchProfileInitialization) {
            this.launchProfileInitialization = launchProfileInitialization != null ? launchProfileInitialization.build() : null;
        }

        @Override
        public final Builder launchProfileInitialization(LaunchProfileInitialization launchProfileInitialization) {
            this.launchProfileInitialization = launchProfileInitialization;
            return this;
        }

        @Override
        public GetLaunchProfileInitializationResponse build() {
            return new GetLaunchProfileInitializationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
