/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.nimble.model.LaunchProfilePlatform;
import software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScriptRunContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StudioComponentInitializationScript
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StudioComponentInitializationScript> {
    private static final SdkField<String> LAUNCH_PROFILE_PROTOCOL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchProfileProtocolVersion").getter(StudioComponentInitializationScript.getter(StudioComponentInitializationScript::launchProfileProtocolVersion)).setter(StudioComponentInitializationScript.setter(Builder::launchProfileProtocolVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfileProtocolVersion").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(StudioComponentInitializationScript.getter(StudioComponentInitializationScript::platformAsString)).setter(StudioComponentInitializationScript.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> RUN_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runContext").getter(StudioComponentInitializationScript.getter(StudioComponentInitializationScript::runContextAsString)).setter(StudioComponentInitializationScript.setter(Builder::runContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runContext").build()}).build();
    private static final SdkField<String> SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("script").getter(StudioComponentInitializationScript.getter(StudioComponentInitializationScript::script)).setter(StudioComponentInitializationScript.setter(Builder::script)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("script").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_PROFILE_PROTOCOL_VERSION_FIELD, PLATFORM_FIELD, RUN_CONTEXT_FIELD, SCRIPT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String launchProfileProtocolVersion;
    private final String platform;
    private final String runContext;
    private final String script;

    private StudioComponentInitializationScript(BuilderImpl builder) {
        this.launchProfileProtocolVersion = builder.launchProfileProtocolVersion;
        this.platform = builder.platform;
        this.runContext = builder.runContext;
        this.script = builder.script;
    }

    public final String launchProfileProtocolVersion() {
        return this.launchProfileProtocolVersion;
    }

    public final LaunchProfilePlatform platform() {
        return LaunchProfilePlatform.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final StudioComponentInitializationScriptRunContext runContext() {
        return StudioComponentInitializationScriptRunContext.fromValue(this.runContext);
    }

    public final String runContextAsString() {
        return this.runContext;
    }

    public final String script() {
        return this.script;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchProfileProtocolVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.runContextAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.script());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StudioComponentInitializationScript)) {
            return false;
        }
        StudioComponentInitializationScript other = (StudioComponentInitializationScript)obj;
        return Objects.equals(this.launchProfileProtocolVersion(), other.launchProfileProtocolVersion()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.runContextAsString(), other.runContextAsString()) && Objects.equals(this.script(), other.script());
    }

    public final String toString() {
        return ToString.builder((String)"StudioComponentInitializationScript").add("LaunchProfileProtocolVersion", (Object)this.launchProfileProtocolVersion()).add("Platform", (Object)this.platformAsString()).add("RunContext", (Object)this.runContextAsString()).add("Script", (Object)(this.script() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "launchProfileProtocolVersion": {
                return Optional.ofNullable(clazz.cast(this.launchProfileProtocolVersion()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "runContext": {
                return Optional.ofNullable(clazz.cast(this.runContextAsString()));
            }
            case "script": {
                return Optional.ofNullable(clazz.cast(this.script()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StudioComponentInitializationScript, T> g) {
        return obj -> g.apply((StudioComponentInitializationScript)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String launchProfileProtocolVersion;
        private String platform;
        private String runContext;
        private String script;

        private BuilderImpl() {
        }

        private BuilderImpl(StudioComponentInitializationScript model) {
            this.launchProfileProtocolVersion(model.launchProfileProtocolVersion);
            this.platform(model.platform);
            this.runContext(model.runContext);
            this.script(model.script);
        }

        public final String getLaunchProfileProtocolVersion() {
            return this.launchProfileProtocolVersion;
        }

        public final void setLaunchProfileProtocolVersion(String launchProfileProtocolVersion) {
            this.launchProfileProtocolVersion = launchProfileProtocolVersion;
        }

        @Override
        public final Builder launchProfileProtocolVersion(String launchProfileProtocolVersion) {
            this.launchProfileProtocolVersion = launchProfileProtocolVersion;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(LaunchProfilePlatform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getRunContext() {
            return this.runContext;
        }

        public final void setRunContext(String runContext) {
            this.runContext = runContext;
        }

        @Override
        public final Builder runContext(String runContext) {
            this.runContext = runContext;
            return this;
        }

        @Override
        public final Builder runContext(StudioComponentInitializationScriptRunContext runContext) {
            this.runContext(runContext == null ? null : runContext.toString());
            return this;
        }

        public final String getScript() {
            return this.script;
        }

        public final void setScript(String script) {
            this.script = script;
        }

        @Override
        public final Builder script(String script) {
            this.script = script;
            return this;
        }

        public StudioComponentInitializationScript build() {
            return new StudioComponentInitializationScript(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StudioComponentInitializationScript> {
        public Builder launchProfileProtocolVersion(String var1);

        public Builder platform(String var1);

        public Builder platform(LaunchProfilePlatform var1);

        public Builder runContext(String var1);

        public Builder runContext(StudioComponentInitializationScriptRunContext var1);

        public Builder script(String var1);
    }
}

