/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.NimbleResponse;
import software.amazon.awssdk.services.nimble.model.Studio;
import software.amazon.awssdk.services.nimble.model.StudioListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStudiosResponse
extends NimbleResponse
implements ToCopyableBuilder<Builder, ListStudiosResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListStudiosResponse.getter(ListStudiosResponse::nextToken)).setter(ListStudiosResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<Studio>> STUDIOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("studios").getter(ListStudiosResponse.getter(ListStudiosResponse::studios)).setter(ListStudiosResponse.setter(Builder::studios)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studios").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Studio::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, STUDIOS_FIELD));
    private final String nextToken;
    private final List<Studio> studios;

    private ListStudiosResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.studios = builder.studios;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasStudios() {
        return this.studios != null && !(this.studios instanceof SdkAutoConstructList);
    }

    public final List<Studio> studios() {
        return this.studios;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStudios() ? this.studios() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStudiosResponse)) {
            return false;
        }
        ListStudiosResponse other = (ListStudiosResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasStudios() == other.hasStudios() && Objects.equals(this.studios(), other.studios());
    }

    public final String toString() {
        return ToString.builder((String)"ListStudiosResponse").add("NextToken", (Object)this.nextToken()).add("Studios", this.hasStudios() ? this.studios() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "studios": {
                return Optional.ofNullable(clazz.cast(this.studios()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStudiosResponse, T> g) {
        return obj -> g.apply((ListStudiosResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Studio> studios = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStudiosResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.studios(model.studios);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<Studio.Builder> getStudios() {
            List<Studio.Builder> result = StudioListCopier.copyToBuilder(this.studios);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder studios(Collection<Studio> studios) {
            this.studios = StudioListCopier.copy(studios);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder studios(Studio ... studios) {
            this.studios(Arrays.asList(studios));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder studios(Consumer<Studio.Builder> ... studios) {
            this.studios(Stream.of(studios).map(c -> (Studio)((Studio.Builder)Studio.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStudios(Collection<Studio.BuilderImpl> studios) {
            this.studios = StudioListCopier.copyFromBuilder(studios);
        }

        @Override
        public ListStudiosResponse build() {
            return new ListStudiosResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStudiosResponse> {
        public Builder nextToken(String var1);

        public Builder studios(Collection<Studio> var1);

        public Builder studios(Studio ... var1);

        public Builder studios(Consumer<Studio.Builder> ... var1);
    }
}

