/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.ActiveDirectoryComputerAttribute;
import software.amazon.awssdk.services.nimble.model.ActiveDirectoryComputerAttributeListCopier;
import software.amazon.awssdk.services.nimble.model.ActiveDirectoryDnsIpAddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchProfileInitializationActiveDirectory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchProfileInitializationActiveDirectory> {
    private static final SdkField<List<ActiveDirectoryComputerAttribute>> COMPUTER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("computerAttributes").getter(LaunchProfileInitializationActiveDirectory.getter(LaunchProfileInitializationActiveDirectory::computerAttributes)).setter(LaunchProfileInitializationActiveDirectory.setter(Builder::computerAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computerAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActiveDirectoryComputerAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("directoryId").getter(LaunchProfileInitializationActiveDirectory.getter(LaunchProfileInitializationActiveDirectory::directoryId)).setter(LaunchProfileInitializationActiveDirectory.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directoryId").build()}).build();
    private static final SdkField<String> DIRECTORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("directoryName").getter(LaunchProfileInitializationActiveDirectory.getter(LaunchProfileInitializationActiveDirectory::directoryName)).setter(LaunchProfileInitializationActiveDirectory.setter(Builder::directoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directoryName").build()}).build();
    private static final SdkField<List<String>> DNS_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dnsIpAddresses").getter(LaunchProfileInitializationActiveDirectory.getter(LaunchProfileInitializationActiveDirectory::dnsIpAddresses)).setter(LaunchProfileInitializationActiveDirectory.setter(Builder::dnsIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsIpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("organizationalUnitDistinguishedName").getter(LaunchProfileInitializationActiveDirectory.getter(LaunchProfileInitializationActiveDirectory::organizationalUnitDistinguishedName)).setter(LaunchProfileInitializationActiveDirectory.setter(Builder::organizationalUnitDistinguishedName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationalUnitDistinguishedName").build()}).build();
    private static final SdkField<String> STUDIO_COMPONENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioComponentId").getter(LaunchProfileInitializationActiveDirectory.getter(LaunchProfileInitializationActiveDirectory::studioComponentId)).setter(LaunchProfileInitializationActiveDirectory.setter(Builder::studioComponentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponentId").build()}).build();
    private static final SdkField<String> STUDIO_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioComponentName").getter(LaunchProfileInitializationActiveDirectory.getter(LaunchProfileInitializationActiveDirectory::studioComponentName)).setter(LaunchProfileInitializationActiveDirectory.setter(Builder::studioComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponentName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTER_ATTRIBUTES_FIELD, DIRECTORY_ID_FIELD, DIRECTORY_NAME_FIELD, DNS_IP_ADDRESSES_FIELD, ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD, STUDIO_COMPONENT_ID_FIELD, STUDIO_COMPONENT_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ActiveDirectoryComputerAttribute> computerAttributes;
    private final String directoryId;
    private final String directoryName;
    private final List<String> dnsIpAddresses;
    private final String organizationalUnitDistinguishedName;
    private final String studioComponentId;
    private final String studioComponentName;

    private LaunchProfileInitializationActiveDirectory(BuilderImpl builder) {
        this.computerAttributes = builder.computerAttributes;
        this.directoryId = builder.directoryId;
        this.directoryName = builder.directoryName;
        this.dnsIpAddresses = builder.dnsIpAddresses;
        this.organizationalUnitDistinguishedName = builder.organizationalUnitDistinguishedName;
        this.studioComponentId = builder.studioComponentId;
        this.studioComponentName = builder.studioComponentName;
    }

    public final boolean hasComputerAttributes() {
        return this.computerAttributes != null && !(this.computerAttributes instanceof SdkAutoConstructList);
    }

    public final List<ActiveDirectoryComputerAttribute> computerAttributes() {
        return this.computerAttributes;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String directoryName() {
        return this.directoryName;
    }

    public final boolean hasDnsIpAddresses() {
        return this.dnsIpAddresses != null && !(this.dnsIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> dnsIpAddresses() {
        return this.dnsIpAddresses;
    }

    public final String organizationalUnitDistinguishedName() {
        return this.organizationalUnitDistinguishedName;
    }

    public final String studioComponentId() {
        return this.studioComponentId;
    }

    public final String studioComponentName() {
        return this.studioComponentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputerAttributes() ? this.computerAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsIpAddresses() ? this.dnsIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitDistinguishedName());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioComponentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioComponentName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchProfileInitializationActiveDirectory)) {
            return false;
        }
        LaunchProfileInitializationActiveDirectory other = (LaunchProfileInitializationActiveDirectory)obj;
        return this.hasComputerAttributes() == other.hasComputerAttributes() && Objects.equals(this.computerAttributes(), other.computerAttributes()) && Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.directoryName(), other.directoryName()) && this.hasDnsIpAddresses() == other.hasDnsIpAddresses() && Objects.equals(this.dnsIpAddresses(), other.dnsIpAddresses()) && Objects.equals(this.organizationalUnitDistinguishedName(), other.organizationalUnitDistinguishedName()) && Objects.equals(this.studioComponentId(), other.studioComponentId()) && Objects.equals(this.studioComponentName(), other.studioComponentName());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchProfileInitializationActiveDirectory").add("ComputerAttributes", this.hasComputerAttributes() ? this.computerAttributes() : null).add("DirectoryId", (Object)this.directoryId()).add("DirectoryName", (Object)this.directoryName()).add("DnsIpAddresses", this.hasDnsIpAddresses() ? this.dnsIpAddresses() : null).add("OrganizationalUnitDistinguishedName", (Object)this.organizationalUnitDistinguishedName()).add("StudioComponentId", (Object)this.studioComponentId()).add("StudioComponentName", (Object)this.studioComponentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computerAttributes": {
                return Optional.ofNullable(clazz.cast(this.computerAttributes()));
            }
            case "directoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "directoryName": {
                return Optional.ofNullable(clazz.cast(this.directoryName()));
            }
            case "dnsIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.dnsIpAddresses()));
            }
            case "organizationalUnitDistinguishedName": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitDistinguishedName()));
            }
            case "studioComponentId": {
                return Optional.ofNullable(clazz.cast(this.studioComponentId()));
            }
            case "studioComponentName": {
                return Optional.ofNullable(clazz.cast(this.studioComponentName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchProfileInitializationActiveDirectory, T> g) {
        return obj -> g.apply((LaunchProfileInitializationActiveDirectory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ActiveDirectoryComputerAttribute> computerAttributes = DefaultSdkAutoConstructList.getInstance();
        private String directoryId;
        private String directoryName;
        private List<String> dnsIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private String organizationalUnitDistinguishedName;
        private String studioComponentId;
        private String studioComponentName;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchProfileInitializationActiveDirectory model) {
            this.computerAttributes(model.computerAttributes);
            this.directoryId(model.directoryId);
            this.directoryName(model.directoryName);
            this.dnsIpAddresses(model.dnsIpAddresses);
            this.organizationalUnitDistinguishedName(model.organizationalUnitDistinguishedName);
            this.studioComponentId(model.studioComponentId);
            this.studioComponentName(model.studioComponentName);
        }

        public final List<ActiveDirectoryComputerAttribute.Builder> getComputerAttributes() {
            List<ActiveDirectoryComputerAttribute.Builder> result = ActiveDirectoryComputerAttributeListCopier.copyToBuilder(this.computerAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder computerAttributes(Collection<ActiveDirectoryComputerAttribute> computerAttributes) {
            this.computerAttributes = ActiveDirectoryComputerAttributeListCopier.copy(computerAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computerAttributes(ActiveDirectoryComputerAttribute ... computerAttributes) {
            this.computerAttributes(Arrays.asList(computerAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computerAttributes(Consumer<ActiveDirectoryComputerAttribute.Builder> ... computerAttributes) {
            this.computerAttributes(Stream.of(computerAttributes).map(c -> (ActiveDirectoryComputerAttribute)((ActiveDirectoryComputerAttribute.Builder)ActiveDirectoryComputerAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComputerAttributes(Collection<ActiveDirectoryComputerAttribute.BuilderImpl> computerAttributes) {
            this.computerAttributes = ActiveDirectoryComputerAttributeListCopier.copyFromBuilder(computerAttributes);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getDirectoryName() {
            return this.directoryName;
        }

        @Override
        public final Builder directoryName(String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public final void setDirectoryName(String directoryName) {
            this.directoryName = directoryName;
        }

        public final Collection<String> getDnsIpAddresses() {
            if (this.dnsIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsIpAddresses;
        }

        @Override
        public final Builder dnsIpAddresses(Collection<String> dnsIpAddresses) {
            this.dnsIpAddresses = ActiveDirectoryDnsIpAddressListCopier.copy(dnsIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIpAddresses(String ... dnsIpAddresses) {
            this.dnsIpAddresses(Arrays.asList(dnsIpAddresses));
            return this;
        }

        public final void setDnsIpAddresses(Collection<String> dnsIpAddresses) {
            this.dnsIpAddresses = ActiveDirectoryDnsIpAddressListCopier.copy(dnsIpAddresses);
        }

        public final String getOrganizationalUnitDistinguishedName() {
            return this.organizationalUnitDistinguishedName;
        }

        @Override
        public final Builder organizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
            return this;
        }

        public final void setOrganizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
        }

        public final String getStudioComponentId() {
            return this.studioComponentId;
        }

        @Override
        public final Builder studioComponentId(String studioComponentId) {
            this.studioComponentId = studioComponentId;
            return this;
        }

        public final void setStudioComponentId(String studioComponentId) {
            this.studioComponentId = studioComponentId;
        }

        public final String getStudioComponentName() {
            return this.studioComponentName;
        }

        @Override
        public final Builder studioComponentName(String studioComponentName) {
            this.studioComponentName = studioComponentName;
            return this;
        }

        public final void setStudioComponentName(String studioComponentName) {
            this.studioComponentName = studioComponentName;
        }

        public LaunchProfileInitializationActiveDirectory build() {
            return new LaunchProfileInitializationActiveDirectory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchProfileInitializationActiveDirectory> {
        public Builder computerAttributes(Collection<ActiveDirectoryComputerAttribute> var1);

        public Builder computerAttributes(ActiveDirectoryComputerAttribute ... var1);

        public Builder computerAttributes(Consumer<ActiveDirectoryComputerAttribute.Builder> ... var1);

        public Builder directoryId(String var1);

        public Builder directoryName(String var1);

        public Builder dnsIpAddresses(Collection<String> var1);

        public Builder dnsIpAddresses(String ... var1);

        public Builder organizationalUnitDistinguishedName(String var1);

        public Builder studioComponentId(String var1);

        public Builder studioComponentName(String var1);
    }
}

