/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.ActiveDirectoryComputerAttribute;
import software.amazon.awssdk.services.nimble.model.ActiveDirectoryComputerAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActiveDirectoryConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActiveDirectoryConfiguration> {
    private static final SdkField<List<ActiveDirectoryComputerAttribute>> COMPUTER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("computerAttributes").getter(ActiveDirectoryConfiguration.getter(ActiveDirectoryConfiguration::computerAttributes)).setter(ActiveDirectoryConfiguration.setter(Builder::computerAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computerAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActiveDirectoryComputerAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("directoryId").getter(ActiveDirectoryConfiguration.getter(ActiveDirectoryConfiguration::directoryId)).setter(ActiveDirectoryConfiguration.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directoryId").build()}).build();
    private static final SdkField<String> ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("organizationalUnitDistinguishedName").getter(ActiveDirectoryConfiguration.getter(ActiveDirectoryConfiguration::organizationalUnitDistinguishedName)).setter(ActiveDirectoryConfiguration.setter(Builder::organizationalUnitDistinguishedName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationalUnitDistinguishedName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTER_ATTRIBUTES_FIELD, DIRECTORY_ID_FIELD, ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ActiveDirectoryComputerAttribute> computerAttributes;
    private final String directoryId;
    private final String organizationalUnitDistinguishedName;

    private ActiveDirectoryConfiguration(BuilderImpl builder) {
        this.computerAttributes = builder.computerAttributes;
        this.directoryId = builder.directoryId;
        this.organizationalUnitDistinguishedName = builder.organizationalUnitDistinguishedName;
    }

    public final boolean hasComputerAttributes() {
        return this.computerAttributes != null && !(this.computerAttributes instanceof SdkAutoConstructList);
    }

    public final List<ActiveDirectoryComputerAttribute> computerAttributes() {
        return this.computerAttributes;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String organizationalUnitDistinguishedName() {
        return this.organizationalUnitDistinguishedName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputerAttributes() ? this.computerAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitDistinguishedName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveDirectoryConfiguration)) {
            return false;
        }
        ActiveDirectoryConfiguration other = (ActiveDirectoryConfiguration)obj;
        return this.hasComputerAttributes() == other.hasComputerAttributes() && Objects.equals(this.computerAttributes(), other.computerAttributes()) && Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.organizationalUnitDistinguishedName(), other.organizationalUnitDistinguishedName());
    }

    public final String toString() {
        return ToString.builder((String)"ActiveDirectoryConfiguration").add("ComputerAttributes", this.hasComputerAttributes() ? this.computerAttributes() : null).add("DirectoryId", (Object)this.directoryId()).add("OrganizationalUnitDistinguishedName", (Object)this.organizationalUnitDistinguishedName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computerAttributes": {
                return Optional.ofNullable(clazz.cast(this.computerAttributes()));
            }
            case "directoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "organizationalUnitDistinguishedName": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitDistinguishedName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActiveDirectoryConfiguration, T> g) {
        return obj -> g.apply((ActiveDirectoryConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ActiveDirectoryComputerAttribute> computerAttributes = DefaultSdkAutoConstructList.getInstance();
        private String directoryId;
        private String organizationalUnitDistinguishedName;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveDirectoryConfiguration model) {
            this.computerAttributes(model.computerAttributes);
            this.directoryId(model.directoryId);
            this.organizationalUnitDistinguishedName(model.organizationalUnitDistinguishedName);
        }

        public final List<ActiveDirectoryComputerAttribute.Builder> getComputerAttributes() {
            List<ActiveDirectoryComputerAttribute.Builder> result = ActiveDirectoryComputerAttributeListCopier.copyToBuilder(this.computerAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder computerAttributes(Collection<ActiveDirectoryComputerAttribute> computerAttributes) {
            this.computerAttributes = ActiveDirectoryComputerAttributeListCopier.copy(computerAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computerAttributes(ActiveDirectoryComputerAttribute ... computerAttributes) {
            this.computerAttributes(Arrays.asList(computerAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computerAttributes(Consumer<ActiveDirectoryComputerAttribute.Builder> ... computerAttributes) {
            this.computerAttributes(Stream.of(computerAttributes).map(c -> (ActiveDirectoryComputerAttribute)((ActiveDirectoryComputerAttribute.Builder)ActiveDirectoryComputerAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComputerAttributes(Collection<ActiveDirectoryComputerAttribute.BuilderImpl> computerAttributes) {
            this.computerAttributes = ActiveDirectoryComputerAttributeListCopier.copyFromBuilder(computerAttributes);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getOrganizationalUnitDistinguishedName() {
            return this.organizationalUnitDistinguishedName;
        }

        @Override
        public final Builder organizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
            return this;
        }

        public final void setOrganizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
        }

        public ActiveDirectoryConfiguration build() {
            return new ActiveDirectoryConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActiveDirectoryConfiguration> {
        public Builder computerAttributes(Collection<ActiveDirectoryComputerAttribute> var1);

        public Builder computerAttributes(ActiveDirectoryComputerAttribute ... var1);

        public Builder computerAttributes(Consumer<ActiveDirectoryComputerAttribute.Builder> ... var1);

        public Builder directoryId(String var1);

        public Builder organizationalUnitDistinguishedName(String var1);
    }
}

