/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteLaunchProfileMemberRequest extends NimbleRequest implements
        ToCopyableBuilder<DeleteLaunchProfileMemberRequest.Builder, DeleteLaunchProfileMemberRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(DeleteLaunchProfileMemberRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> LAUNCH_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchProfileId").getter(getter(DeleteLaunchProfileMemberRequest::launchProfileId))
            .setter(setter(Builder::launchProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("launchProfileId").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalId").getter(getter(DeleteLaunchProfileMemberRequest::principalId))
            .setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("principalId").build()).build();

    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("studioId").getter(getter(DeleteLaunchProfileMemberRequest::studioId)).setter(setter(Builder::studioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            LAUNCH_PROFILE_ID_FIELD, PRINCIPAL_ID_FIELD, STUDIO_ID_FIELD));

    private final String clientToken;

    private final String launchProfileId;

    private final String principalId;

    private final String studioId;

    private DeleteLaunchProfileMemberRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.launchProfileId = builder.launchProfileId;
        this.principalId = builder.principalId;
        this.studioId = builder.studioId;
    }

    /**
     * <p>
     * To make an idempotent API request using one of these actions, specify a client token in the request. You should
     * not reuse the same client token for other API requests. If you retry a request that completed successfully using
     * the same client token and the same parameters, the retry succeeds without performing any further actions. If you
     * retry a successful request using the same client token, but one or more of the parameters are different, the
     * retry fails with a ValidationException error.
     * </p>
     * 
     * @return To make an idempotent API request using one of these actions, specify a client token in the request. You
     *         should not reuse the same client token for other API requests. If you retry a request that completed
     *         successfully using the same client token and the same parameters, the retry succeeds without performing
     *         any further actions. If you retry a successful request using the same client token, but one or more of
     *         the parameters are different, the retry fails with a ValidationException error.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The launch profile ID.
     * </p>
     * 
     * @return The launch profile ID.
     */
    public final String launchProfileId() {
        return launchProfileId;
    }

    /**
     * <p>
     * The principal ID.
     * </p>
     * 
     * @return The principal ID.
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The studio ID.
     * </p>
     * 
     * @return The studio ID.
     */
    public final String studioId() {
        return studioId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(launchProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(studioId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLaunchProfileMemberRequest)) {
            return false;
        }
        DeleteLaunchProfileMemberRequest other = (DeleteLaunchProfileMemberRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(launchProfileId(), other.launchProfileId())
                && Objects.equals(principalId(), other.principalId()) && Objects.equals(studioId(), other.studioId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteLaunchProfileMemberRequest").add("ClientToken", clientToken())
                .add("LaunchProfileId", launchProfileId()).add("PrincipalId", principalId()).add("StudioId", studioId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "launchProfileId":
            return Optional.ofNullable(clazz.cast(launchProfileId()));
        case "principalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "studioId":
            return Optional.ofNullable(clazz.cast(studioId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteLaunchProfileMemberRequest, T> g) {
        return obj -> g.apply((DeleteLaunchProfileMemberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteLaunchProfileMemberRequest> {
        /**
         * <p>
         * To make an idempotent API request using one of these actions, specify a client token in the request. You
         * should not reuse the same client token for other API requests. If you retry a request that completed
         * successfully using the same client token and the same parameters, the retry succeeds without performing any
         * further actions. If you retry a successful request using the same client token, but one or more of the
         * parameters are different, the retry fails with a ValidationException error.
         * </p>
         * 
         * @param clientToken
         *        To make an idempotent API request using one of these actions, specify a client token in the request.
         *        You should not reuse the same client token for other API requests. If you retry a request that
         *        completed successfully using the same client token and the same parameters, the retry succeeds without
         *        performing any further actions. If you retry a successful request using the same client token, but one
         *        or more of the parameters are different, the retry fails with a ValidationException error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The launch profile ID.
         * </p>
         * 
         * @param launchProfileId
         *        The launch profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchProfileId(String launchProfileId);

        /**
         * <p>
         * The principal ID.
         * </p>
         * 
         * @param principalId
         *        The principal ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The studio ID.
         * </p>
         * 
         * @param studioId
         *        The studio ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioId(String studioId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NimbleRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String launchProfileId;

        private String principalId;

        private String studioId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLaunchProfileMemberRequest model) {
            super(model);
            clientToken(model.clientToken);
            launchProfileId(model.launchProfileId);
            principalId(model.principalId);
            studioId(model.studioId);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getLaunchProfileId() {
            return launchProfileId;
        }

        @Override
        public final Builder launchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
            return this;
        }

        public final void setLaunchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final String getStudioId() {
            return studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLaunchProfileMemberRequest build() {
            return new DeleteLaunchProfileMemberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
