/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.ConnectionHealth;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkTelemetry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkTelemetry> {
    private static final SdkField<String> REGISTERED_GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegisteredGatewayArn").getter(NetworkTelemetry.getter(NetworkTelemetry::registeredGatewayArn)).setter(NetworkTelemetry.setter(Builder::registeredGatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredGatewayArn").build()}).build();
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkId").getter(NetworkTelemetry.getter(NetworkTelemetry::coreNetworkId)).setter(NetworkTelemetry.setter(Builder::coreNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsRegion").getter(NetworkTelemetry.getter(NetworkTelemetry::awsRegion)).setter(NetworkTelemetry.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(NetworkTelemetry.getter(NetworkTelemetry::accountId)).setter(NetworkTelemetry.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(NetworkTelemetry.getter(NetworkTelemetry::resourceType)).setter(NetworkTelemetry.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(NetworkTelemetry.getter(NetworkTelemetry::resourceId)).setter(NetworkTelemetry.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(NetworkTelemetry.getter(NetworkTelemetry::resourceArn)).setter(NetworkTelemetry.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Address").getter(NetworkTelemetry.getter(NetworkTelemetry::address)).setter(NetworkTelemetry.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<ConnectionHealth> HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Health").getter(NetworkTelemetry.getter(NetworkTelemetry::health)).setter(NetworkTelemetry.setter(Builder::health)).constructor(ConnectionHealth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Health").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTERED_GATEWAY_ARN_FIELD, CORE_NETWORK_ID_FIELD, AWS_REGION_FIELD, ACCOUNT_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, RESOURCE_ARN_FIELD, ADDRESS_FIELD, HEALTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkTelemetry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String registeredGatewayArn;
    private final String coreNetworkId;
    private final String awsRegion;
    private final String accountId;
    private final String resourceType;
    private final String resourceId;
    private final String resourceArn;
    private final String address;
    private final ConnectionHealth health;

    private NetworkTelemetry(BuilderImpl builder) {
        this.registeredGatewayArn = builder.registeredGatewayArn;
        this.coreNetworkId = builder.coreNetworkId;
        this.awsRegion = builder.awsRegion;
        this.accountId = builder.accountId;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceArn = builder.resourceArn;
        this.address = builder.address;
        this.health = builder.health;
    }

    public final String registeredGatewayArn() {
        return this.registeredGatewayArn;
    }

    public final String coreNetworkId() {
        return this.coreNetworkId;
    }

    public final String awsRegion() {
        return this.awsRegion;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String address() {
        return this.address;
    }

    public final ConnectionHealth health() {
        return this.health;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredGatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.health());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkTelemetry)) {
            return false;
        }
        NetworkTelemetry other = (NetworkTelemetry)obj;
        return Objects.equals(this.registeredGatewayArn(), other.registeredGatewayArn()) && Objects.equals(this.coreNetworkId(), other.coreNetworkId()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.address(), other.address()) && Objects.equals(this.health(), other.health());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkTelemetry").add("RegisteredGatewayArn", (Object)this.registeredGatewayArn()).add("CoreNetworkId", (Object)this.coreNetworkId()).add("AwsRegion", (Object)this.awsRegion()).add("AccountId", (Object)this.accountId()).add("ResourceType", (Object)this.resourceType()).add("ResourceId", (Object)this.resourceId()).add("ResourceArn", (Object)this.resourceArn()).add("Address", (Object)this.address()).add("Health", (Object)this.health()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegisteredGatewayArn": {
                return Optional.ofNullable(clazz.cast(this.registeredGatewayArn()));
            }
            case "CoreNetworkId": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkId()));
            }
            case "AwsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "Health": {
                return Optional.ofNullable(clazz.cast(this.health()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RegisteredGatewayArn", REGISTERED_GATEWAY_ARN_FIELD);
        map.put("CoreNetworkId", CORE_NETWORK_ID_FIELD);
        map.put("AwsRegion", AWS_REGION_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("Address", ADDRESS_FIELD);
        map.put("Health", HEALTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkTelemetry, T> g) {
        return obj -> g.apply((NetworkTelemetry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String registeredGatewayArn;
        private String coreNetworkId;
        private String awsRegion;
        private String accountId;
        private String resourceType;
        private String resourceId;
        private String resourceArn;
        private String address;
        private ConnectionHealth health;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkTelemetry model) {
            this.registeredGatewayArn(model.registeredGatewayArn);
            this.coreNetworkId(model.coreNetworkId);
            this.awsRegion(model.awsRegion);
            this.accountId(model.accountId);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.resourceArn(model.resourceArn);
            this.address(model.address);
            this.health(model.health);
        }

        public final String getRegisteredGatewayArn() {
            return this.registeredGatewayArn;
        }

        public final void setRegisteredGatewayArn(String registeredGatewayArn) {
            this.registeredGatewayArn = registeredGatewayArn;
        }

        @Override
        public final Builder registeredGatewayArn(String registeredGatewayArn) {
            this.registeredGatewayArn = registeredGatewayArn;
            return this;
        }

        public final String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getAddress() {
            return this.address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final ConnectionHealth.Builder getHealth() {
            return this.health != null ? this.health.toBuilder() : null;
        }

        public final void setHealth(ConnectionHealth.BuilderImpl health) {
            this.health = health != null ? health.build() : null;
        }

        @Override
        public final Builder health(ConnectionHealth health) {
            this.health = health;
            return this;
        }

        public NetworkTelemetry build() {
            return new NetworkTelemetry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkTelemetry> {
        public Builder registeredGatewayArn(String var1);

        public Builder coreNetworkId(String var1);

        public Builder awsRegion(String var1);

        public Builder accountId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceId(String var1);

        public Builder resourceArn(String var1);

        public Builder address(String var1);

        public Builder health(ConnectionHealth var1);

        default public Builder health(Consumer<ConnectionHealth.Builder> health) {
            return this.health((ConnectionHealth)((ConnectionHealth.Builder)ConnectionHealth.builder().applyMutation(health)).build());
        }
    }
}

