/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.Device;
import software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest;
import software.amazon.awssdk.services.networkmanager.model.GetDevicesResponse;

public class GetDevicesPublisher
implements SdkPublisher<GetDevicesResponse> {
    private final NetworkManagerAsyncClient client;
    private final GetDevicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetDevicesPublisher(NetworkManagerAsyncClient client, GetDevicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetDevicesPublisher(NetworkManagerAsyncClient client, GetDevicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetDevicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetDevicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Device> devices() {
        Function<GetDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.devices() != null) {
                return response.devices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetDevicesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetDevicesResponseFetcher
    implements AsyncPageFetcher<GetDevicesResponse> {
        private GetDevicesResponseFetcher() {
        }

        public boolean hasNextPage(GetDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetDevicesResponse> nextPage(GetDevicesResponse previousPage) {
            if (previousPage == null) {
                return GetDevicesPublisher.this.client.getDevices(GetDevicesPublisher.this.firstRequest);
            }
            return GetDevicesPublisher.this.client.getDevices((GetDevicesRequest)((Object)GetDevicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

