/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PeeringErrorCode {
    TRANSIT_GATEWAY_NOT_FOUND("TRANSIT_GATEWAY_NOT_FOUND"),
    TRANSIT_GATEWAY_PEERS_LIMIT_EXCEEDED("TRANSIT_GATEWAY_PEERS_LIMIT_EXCEEDED"),
    MISSING_PERMISSIONS("MISSING_PERMISSIONS"),
    INTERNAL_ERROR("INTERNAL_ERROR"),
    EDGE_LOCATION_PEER_DUPLICATE("EDGE_LOCATION_PEER_DUPLICATE"),
    INVALID_TRANSIT_GATEWAY_STATE("INVALID_TRANSIT_GATEWAY_STATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PeeringErrorCode> VALUE_MAP;
    private final String value;

    private PeeringErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PeeringErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PeeringErrorCode> knownValues() {
        EnumSet<PeeringErrorCode> knownValues = EnumSet.allOf(PeeringErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PeeringErrorCode.class, PeeringErrorCode::toString);
    }
}

