/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePrivateGraphEndpointResponse extends NeptuneGraphResponse implements
        ToCopyableBuilder<CreatePrivateGraphEndpointResponse.Builder, CreatePrivateGraphEndpointResponse> {
    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vpcId")
            .getter(getter(CreatePrivateGraphEndpointResponse::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIds")
            .getter(getter(CreatePrivateGraphEndpointResponse::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreatePrivateGraphEndpointResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpcEndpointId").getter(getter(CreatePrivateGraphEndpointResponse::vpcEndpointId))
            .setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ID_FIELD,
            SUBNET_IDS_FIELD, STATUS_FIELD, VPC_ENDPOINT_ID_FIELD));

    private final String vpcId;

    private final List<String> subnetIds;

    private final String status;

    private final String vpcEndpointId;

    private CreatePrivateGraphEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.vpcId = builder.vpcId;
        this.subnetIds = builder.subnetIds;
        this.status = builder.status;
        this.vpcEndpointId = builder.vpcEndpointId;
    }

    /**
     * <p>
     * VPC in which the private graph endpoint is created.
     * </p>
     * 
     * @return VPC in which the private graph endpoint is created.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Subnets in which the private graph endpoint ENIs are created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return Subnets in which the private graph endpoint ENIs are created.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * Status of the private graph endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PrivateGraphEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the private graph endpoint.
     * @see PrivateGraphEndpointStatus
     */
    public final PrivateGraphEndpointStatus status() {
        return PrivateGraphEndpointStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the private graph endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PrivateGraphEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the private graph endpoint.
     * @see PrivateGraphEndpointStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Endpoint ID of the prviate grpah endpoint.
     * </p>
     * 
     * @return Endpoint ID of the prviate grpah endpoint.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePrivateGraphEndpointResponse)) {
            return false;
        }
        CreatePrivateGraphEndpointResponse other = (CreatePrivateGraphEndpointResponse) obj;
        return Objects.equals(vpcId(), other.vpcId()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(vpcEndpointId(), other.vpcEndpointId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePrivateGraphEndpointResponse").add("VpcId", vpcId())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("Status", statusAsString())
                .add("VpcEndpointId", vpcEndpointId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "vpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePrivateGraphEndpointResponse, T> g) {
        return obj -> g.apply((CreatePrivateGraphEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneGraphResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePrivateGraphEndpointResponse> {
        /**
         * <p>
         * VPC in which the private graph endpoint is created.
         * </p>
         * 
         * @param vpcId
         *        VPC in which the private graph endpoint is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Subnets in which the private graph endpoint ENIs are created.
         * </p>
         * 
         * @param subnetIds
         *        Subnets in which the private graph endpoint ENIs are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * Subnets in which the private graph endpoint ENIs are created.
         * </p>
         * 
         * @param subnetIds
         *        Subnets in which the private graph endpoint ENIs are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * Status of the private graph endpoint.
         * </p>
         * 
         * @param status
         *        Status of the private graph endpoint.
         * @see PrivateGraphEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivateGraphEndpointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the private graph endpoint.
         * </p>
         * 
         * @param status
         *        Status of the private graph endpoint.
         * @see PrivateGraphEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivateGraphEndpointStatus
         */
        Builder status(PrivateGraphEndpointStatus status);

        /**
         * <p>
         * Endpoint ID of the prviate grpah endpoint.
         * </p>
         * 
         * @param vpcEndpointId
         *        Endpoint ID of the prviate grpah endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);
    }

    static final class BuilderImpl extends NeptuneGraphResponse.BuilderImpl implements Builder {
        private String vpcId;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String vpcEndpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePrivateGraphEndpointResponse model) {
            super(model);
            vpcId(model.vpcId);
            subnetIds(model.subnetIds);
            status(model.status);
            vpcEndpointId(model.vpcEndpointId);
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PrivateGraphEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        @Override
        public CreatePrivateGraphEndpointResponse build() {
            return new CreatePrivateGraphEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
