/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GraphStatus {
    CREATING("CREATING"),
    AVAILABLE("AVAILABLE"),
    DELETING("DELETING"),
    RESETTING("RESETTING"),
    UPDATING("UPDATING"),
    SNAPSHOTTING("SNAPSHOTTING"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GraphStatus> VALUE_MAP;
    private final String value;

    private GraphStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GraphStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GraphStatus> knownValues() {
        EnumSet<GraphStatus> knownValues = EnumSet.allOf(GraphStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GraphStatus.class, GraphStatus::toString);
    }
}

