/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphClient;
import software.amazon.awssdk.services.neptunegraph.internal.UserAgentUtils;
import software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsResponse;
import software.amazon.awssdk.services.neptunegraph.model.PrivateGraphEndpointSummary;

public class ListPrivateGraphEndpointsIterable
implements SdkIterable<ListPrivateGraphEndpointsResponse> {
    private final NeptuneGraphClient client;
    private final ListPrivateGraphEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPrivateGraphEndpointsIterable(NeptuneGraphClient client, ListPrivateGraphEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPrivateGraphEndpointsResponseFetcher();
    }

    public Iterator<ListPrivateGraphEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PrivateGraphEndpointSummary> privateGraphEndpoints() {
        Function<ListPrivateGraphEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.privateGraphEndpoints() != null) {
                return response.privateGraphEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPrivateGraphEndpointsResponseFetcher
    implements SyncPageFetcher<ListPrivateGraphEndpointsResponse> {
        private ListPrivateGraphEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListPrivateGraphEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPrivateGraphEndpointsResponse nextPage(ListPrivateGraphEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListPrivateGraphEndpointsIterable.this.client.listPrivateGraphEndpoints(ListPrivateGraphEndpointsIterable.this.firstRequest);
            }
            return ListPrivateGraphEndpointsIterable.this.client.listPrivateGraphEndpoints((ListPrivateGraphEndpointsRequest)((Object)ListPrivateGraphEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

