/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImportTasksResponse extends NeptuneGraphResponse implements
        ToCopyableBuilder<ListImportTasksResponse.Builder, ListImportTasksResponse> {
    private static final SdkField<List<ImportTaskSummary>> TASKS_FIELD = SdkField
            .<List<ImportTaskSummary>> builder(MarshallingType.LIST)
            .memberName("tasks")
            .getter(getter(ListImportTasksResponse::tasks))
            .setter(setter(Builder::tasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImportTaskSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportTaskSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListImportTasksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TASKS_FIELD, NEXT_TOKEN_FIELD));

    private final List<ImportTaskSummary> tasks;

    private final String nextToken;

    private ListImportTasksResponse(BuilderImpl builder) {
        super(builder);
        this.tasks = builder.tasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tasks property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTasks() {
        return tasks != null && !(tasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The requested list of import tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTasks} method.
     * </p>
     * 
     * @return The requested list of import tasks.
     */
    public final List<ImportTaskSummary> tasks() {
        return tasks;
    }

    /**
     * <p>
     * Pagination token used to paginate output.
     * </p>
     * <p>
     * When this value is provided as input, the service returns results from where the previous response left off. When
     * this value is present in output, it indicates that there are more results to retrieve.
     * </p>
     * 
     * @return Pagination token used to paginate output.</p>
     *         <p>
     *         When this value is provided as input, the service returns results from where the previous response left
     *         off. When this value is present in output, it indicates that there are more results to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTasks() ? tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportTasksResponse)) {
            return false;
        }
        ListImportTasksResponse other = (ListImportTasksResponse) obj;
        return hasTasks() == other.hasTasks() && Objects.equals(tasks(), other.tasks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImportTasksResponse").add("Tasks", hasTasks() ? tasks() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tasks":
            return Optional.ofNullable(clazz.cast(tasks()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImportTasksResponse, T> g) {
        return obj -> g.apply((ListImportTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneGraphResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListImportTasksResponse> {
        /**
         * <p>
         * The requested list of import tasks.
         * </p>
         * 
         * @param tasks
         *        The requested list of import tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(Collection<ImportTaskSummary> tasks);

        /**
         * <p>
         * The requested list of import tasks.
         * </p>
         * 
         * @param tasks
         *        The requested list of import tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(ImportTaskSummary... tasks);

        /**
         * <p>
         * The requested list of import tasks.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.neptunegraph.model.ImportTaskSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.neptunegraph.model.ImportTaskSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.neptunegraph.model.ImportTaskSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #tasks(List<ImportTaskSummary>)}.
         * 
         * @param tasks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.neptunegraph.model.ImportTaskSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tasks(java.util.Collection<ImportTaskSummary>)
         */
        Builder tasks(Consumer<ImportTaskSummary.Builder>... tasks);

        /**
         * <p>
         * Pagination token used to paginate output.
         * </p>
         * <p>
         * When this value is provided as input, the service returns results from where the previous response left off.
         * When this value is present in output, it indicates that there are more results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        Pagination token used to paginate output.</p>
         *        <p>
         *        When this value is provided as input, the service returns results from where the previous response
         *        left off. When this value is present in output, it indicates that there are more results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NeptuneGraphResponse.BuilderImpl implements Builder {
        private List<ImportTaskSummary> tasks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportTasksResponse model) {
            super(model);
            tasks(model.tasks);
            nextToken(model.nextToken);
        }

        public final List<ImportTaskSummary.Builder> getTasks() {
            List<ImportTaskSummary.Builder> result = ImportTaskSummaryListCopier.copyToBuilder(this.tasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTasks(Collection<ImportTaskSummary.BuilderImpl> tasks) {
            this.tasks = ImportTaskSummaryListCopier.copyFromBuilder(tasks);
        }

        @Override
        public final Builder tasks(Collection<ImportTaskSummary> tasks) {
            this.tasks = ImportTaskSummaryListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(ImportTaskSummary... tasks) {
            tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<ImportTaskSummary.Builder>... tasks) {
            tasks(Stream.of(tasks).map(c -> ImportTaskSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImportTasksResponse build() {
            return new ListImportTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
