/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An exception indicating that a server-side error occurred during the Apache Airflow REST API call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestApiServerException extends MwaaException implements
        ToCopyableBuilder<RestApiServerException.Builder, RestApiServerException> {
    private static final SdkField<Integer> REST_API_STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RestApiStatusCode").getter(getter(RestApiServerException::restApiStatusCode))
            .setter(setter(Builder::restApiStatusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestApiStatusCode").build()).build();

    private static final SdkField<Document> REST_API_RESPONSE_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("RestApiResponse").getter(getter(RestApiServerException::restApiResponse))
            .setter(setter(Builder::restApiResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestApiResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_STATUS_CODE_FIELD,
            REST_API_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer restApiStatusCode;

    private final Document restApiResponse;

    private RestApiServerException(BuilderImpl builder) {
        super(builder);
        this.restApiStatusCode = builder.restApiStatusCode;
        this.restApiResponse = builder.restApiResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The HTTP status code returned by the Apache Airflow REST API call.
     * </p>
     * 
     * @return The HTTP status code returned by the Apache Airflow REST API call.
     */
    public Integer restApiStatusCode() {
        return restApiStatusCode;
    }

    /**
     * <p>
     * The error response data from the Apache Airflow REST API call, provided as a JSON object.
     * </p>
     * 
     * @return The error response data from the Apache Airflow REST API call, provided as a JSON object.
     */
    public Document restApiResponse() {
        return restApiResponse;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RestApiStatusCode", REST_API_STATUS_CODE_FIELD);
        map.put("RestApiResponse", REST_API_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestApiServerException, T> g) {
        return obj -> g.apply((RestApiServerException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RestApiServerException>, MwaaException.Builder {
        /**
         * <p>
         * The HTTP status code returned by the Apache Airflow REST API call.
         * </p>
         * 
         * @param restApiStatusCode
         *        The HTTP status code returned by the Apache Airflow REST API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiStatusCode(Integer restApiStatusCode);

        /**
         * <p>
         * The error response data from the Apache Airflow REST API call, provided as a JSON object.
         * </p>
         * 
         * @param restApiResponse
         *        The error response data from the Apache Airflow REST API call, provided as a JSON object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiResponse(Document restApiResponse);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends MwaaException.BuilderImpl implements Builder {
        private Integer restApiStatusCode;

        private Document restApiResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(RestApiServerException model) {
            super(model);
            restApiStatusCode(model.restApiStatusCode);
            restApiResponse(model.restApiResponse);
        }

        public final Integer getRestApiStatusCode() {
            return restApiStatusCode;
        }

        public final void setRestApiStatusCode(Integer restApiStatusCode) {
            this.restApiStatusCode = restApiStatusCode;
        }

        @Override
        public final Builder restApiStatusCode(Integer restApiStatusCode) {
            this.restApiStatusCode = restApiStatusCode;
            return this;
        }

        public final Document getRestApiResponse() {
            return restApiResponse;
        }

        public final void setRestApiResponse(Document restApiResponse) {
            this.restApiResponse = restApiResponse;
        }

        @Override
        public final Builder restApiResponse(Document restApiResponse) {
            this.restApiResponse = restApiResponse;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public RestApiServerException build() {
            return new RestApiServerException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
